/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.util.ArrayList;
import java.util.List;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.ParamDescription;
import tech.ydb.jdbc.query.QueryCmd;
import tech.ydb.jdbc.query.QueryType;

public class QueryStatement {
    private final QueryType queryType;
    private final QueryCmd command;
    private final List<ParamDescription> parameters = new ArrayList<ParamDescription>();
    private boolean hasReturinng = false;

    public QueryStatement(QueryType type, QueryCmd command) {
        this.queryType = type;
        this.command = command;
    }

    public QueryType getType() {
        return this.queryType;
    }

    public List<ParamDescription> getParams() {
        return this.parameters;
    }

    public void addParameter(String name, TypeDescription type) {
        this.parameters.add(new ParamDescription(name, type));
    }

    public void setHasReturning(boolean hasReturning) {
        this.hasReturinng = hasReturning;
    }

    public boolean hasUpdateCount() {
        return (this.command == QueryCmd.INSERT_UPSERT || this.command == QueryCmd.UPDATE_REPLACE_DELETE) && !this.hasReturinng;
    }

    public boolean hasResults() {
        return this.command == QueryCmd.SELECT || this.hasReturinng;
    }

    public boolean isDDL() {
        return this.command == QueryCmd.CREATE_ALTER_DROP;
    }
}

