/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.ydb.table.values.DecimalType;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.VoidType;

public class YdbTypes {
    private static final YdbTypes INSTANCE = new YdbTypes();
    private final IntObjectMap<Type> typeBySqlType = new IntObjectHashMap(18 + PrimitiveType.values().length);
    private final Map<Class<?>, Type> typeByClass;
    private final Map<Type, Integer> sqlTypeByPrimitiveNumId;

    private YdbTypes() {
        for (PrimitiveType type : PrimitiveType.values()) {
            this.typeBySqlType.put(10000 + type.ordinal(), (Object)type);
        }
        this.typeBySqlType.put(12, (Object)PrimitiveType.Text);
        this.typeBySqlType.put(-5, (Object)PrimitiveType.Int64);
        this.typeBySqlType.put(-6, (Object)PrimitiveType.Int8);
        this.typeBySqlType.put(5, (Object)PrimitiveType.Int16);
        this.typeBySqlType.put(4, (Object)PrimitiveType.Int32);
        this.typeBySqlType.put(7, (Object)PrimitiveType.Float);
        this.typeBySqlType.put(6, (Object)PrimitiveType.Float);
        this.typeBySqlType.put(8, (Object)PrimitiveType.Double);
        this.typeBySqlType.put(-7, (Object)PrimitiveType.Bool);
        this.typeBySqlType.put(16, (Object)PrimitiveType.Bool);
        this.typeBySqlType.put(-2, (Object)PrimitiveType.Bytes);
        this.typeBySqlType.put(-3, (Object)PrimitiveType.Bytes);
        this.typeBySqlType.put(91, (Object)PrimitiveType.Date);
        this.typeBySqlType.put(93, (Object)PrimitiveType.Timestamp);
        this.typeBySqlType.put(92, (Object)PrimitiveType.Int32);
        this.typeBySqlType.put(2014, (Object)PrimitiveType.TzTimestamp);
        this.typeBySqlType.put(3, (Object)DecimalType.getDefault());
        this.typeBySqlType.put(2, (Object)DecimalType.getDefault());
        this.typeByClass = new HashMap();
        this.typeByClass.put(Boolean.TYPE, (Type)PrimitiveType.Bool);
        this.typeByClass.put(Boolean.class, (Type)PrimitiveType.Bool);
        this.typeByClass.put(Byte.TYPE, (Type)PrimitiveType.Int8);
        this.typeByClass.put(Byte.class, (Type)PrimitiveType.Int8);
        this.typeByClass.put(Short.TYPE, (Type)PrimitiveType.Int16);
        this.typeByClass.put(Short.class, (Type)PrimitiveType.Int16);
        this.typeByClass.put(Integer.TYPE, (Type)PrimitiveType.Int32);
        this.typeByClass.put(Integer.class, (Type)PrimitiveType.Int32);
        this.typeByClass.put(Long.TYPE, (Type)PrimitiveType.Int64);
        this.typeByClass.put(Long.class, (Type)PrimitiveType.Int64);
        this.typeByClass.put(BigInteger.class, (Type)PrimitiveType.Int64);
        this.typeByClass.put(Float.TYPE, (Type)PrimitiveType.Float);
        this.typeByClass.put(Float.class, (Type)PrimitiveType.Float);
        this.typeByClass.put(Double.TYPE, (Type)PrimitiveType.Double);
        this.typeByClass.put(Double.class, (Type)PrimitiveType.Double);
        this.typeByClass.put(String.class, (Type)PrimitiveType.Text);
        this.typeByClass.put(byte[].class, (Type)PrimitiveType.Bytes);
        this.typeByClass.put(Date.class, (Type)PrimitiveType.Date);
        this.typeByClass.put(LocalDate.class, (Type)PrimitiveType.Date);
        this.typeByClass.put(LocalDateTime.class, (Type)PrimitiveType.Datetime);
        this.typeByClass.put(java.util.Date.class, (Type)PrimitiveType.Timestamp);
        this.typeByClass.put(Timestamp.class, (Type)PrimitiveType.Timestamp);
        this.typeByClass.put(Instant.class, (Type)PrimitiveType.Timestamp);
        this.typeByClass.put(LocalTime.class, (Type)PrimitiveType.Int32);
        this.typeByClass.put(Time.class, (Type)PrimitiveType.Int32);
        this.typeByClass.put(DecimalValue.class, (Type)DecimalType.getDefault());
        this.typeByClass.put(BigDecimal.class, (Type)DecimalType.getDefault());
        this.typeByClass.put(Duration.class, (Type)PrimitiveType.Interval);
        this.sqlTypeByPrimitiveNumId = new HashMap<Type, Integer>(PrimitiveType.values().length);
        for (PrimitiveType id : PrimitiveType.values()) {
            int sqlType;
            switch (id) {
                case Text: 
                case Json: 
                case JsonDocument: 
                case Uuid: {
                    sqlType = 12;
                    break;
                }
                case Bytes: 
                case Yson: {
                    sqlType = -2;
                    break;
                }
                case Bool: {
                    sqlType = 16;
                    break;
                }
                case Int8: 
                case Int16: {
                    sqlType = 5;
                    break;
                }
                case Uint8: 
                case Int32: 
                case Uint16: {
                    sqlType = 4;
                    break;
                }
                case Uint32: 
                case Int64: 
                case Uint64: 
                case Interval: {
                    sqlType = -5;
                    break;
                }
                case Float: {
                    sqlType = 6;
                    break;
                }
                case Double: {
                    sqlType = 8;
                    break;
                }
                case Date: {
                    sqlType = 91;
                    break;
                }
                case Datetime: {
                    sqlType = 93;
                    break;
                }
                case Timestamp: {
                    sqlType = 93;
                    break;
                }
                case TzDate: 
                case TzDatetime: 
                case TzTimestamp: {
                    sqlType = 2014;
                    break;
                }
                default: {
                    sqlType = 2000;
                }
            }
            this.sqlTypeByPrimitiveNumId.put((Type)id, sqlType);
        }
    }

    public static Type findType(Object obj, int sqlType) {
        return INSTANCE.findTypeImpl(obj, sqlType);
    }

    private Type findTypeImpl(Object obj, int sqlType) {
        if (this.typeBySqlType.containsKey(sqlType)) {
            return (Type)this.typeBySqlType.get(sqlType);
        }
        if (obj == null) {
            return VoidType.of();
        }
        if (obj instanceof Value) {
            return ((Value)obj).getType();
        }
        return this.typeByClass.get(obj.getClass());
    }

    public static int toSqlType(Type type) {
        return INSTANCE.toSqlTypeImpl(type);
    }

    private int toSqlTypeImpl(Type type) {
        switch (type.getKind()) {
            case OPTIONAL: {
                return this.toSqlTypeImpl(type.unwrapOptional());
            }
            case DECIMAL: {
                return 3;
            }
            case NULL: 
            case VOID: {
                return 0;
            }
            case PG_TYPE: {
                return 1111;
            }
            case PRIMITIVE: {
                if (!this.sqlTypeByPrimitiveNumId.containsKey(type)) {
                    throw new RuntimeException("Internal error. Unsupported YDB type: " + type);
                }
                return this.sqlTypeByPrimitiveNumId.get(type);
            }
        }
        throw new RuntimeException("Internal error. Unsupported YDB kind: " + type);
    }

    public static int getSqlPrecision(Type type) {
        return INSTANCE.getSqlPrecisionImpl(type);
    }

    private int getSqlPrecisionImpl(Type type) {
        switch (type.getKind()) {
            case OPTIONAL: {
                return this.getSqlPrecisionImpl(type.unwrapOptional());
            }
            case DECIMAL: {
                return 16;
            }
            case PRIMITIVE: {
                return this.getSqlPrecisionImpl((PrimitiveType)type);
            }
        }
        return 0;
    }

    public static List<Type> getAllDatabaseTypes() {
        return INSTANCE.getAllDatabaseTypesImpl();
    }

    private List<Type> getAllDatabaseTypesImpl() {
        return Arrays.asList(PrimitiveType.Bool, PrimitiveType.Int8, PrimitiveType.Int16, PrimitiveType.Int32, PrimitiveType.Int64, PrimitiveType.Uint8, PrimitiveType.Uint16, PrimitiveType.Uint32, PrimitiveType.Uint64, PrimitiveType.Float, PrimitiveType.Double, PrimitiveType.Bytes, PrimitiveType.Text, PrimitiveType.Json, PrimitiveType.JsonDocument, PrimitiveType.Yson, PrimitiveType.Date, PrimitiveType.Datetime, PrimitiveType.Timestamp, PrimitiveType.Interval, DecimalType.getDefault());
    }

    private int getSqlPrecisionImpl(PrimitiveType type) {
        switch (type) {
            case Bool: 
            case Int8: 
            case Uint8: {
                return 1;
            }
            case Int16: 
            case Uint16: {
                return 2;
            }
            case Int32: 
            case Uint32: 
            case Float: {
                return 4;
            }
            case Int64: 
            case Uint64: 
            case Interval: 
            case Double: {
                return 8;
            }
            case Text: 
            case Json: 
            case JsonDocument: 
            case Bytes: 
            case Yson: {
                return 0x400000;
            }
            case Uuid: {
                return 16;
            }
            case Date: {
                return "0000-00-00".length();
            }
            case Datetime: {
                return "0000-00-00 00:00:00".length();
            }
            case Timestamp: {
                return "0000-00-00T00:00:00.000000".length();
            }
            case TzDate: {
                return "0000-00-00+00:00".length();
            }
            case TzDatetime: {
                return "0000-00-00 00:00:00+00:00".length();
            }
            case TzTimestamp: {
                return "0000-00-00T00:00:00.000000+00:00".length();
            }
        }
        return 0;
    }
}

