/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.SQLException;
import tech.ydb.jdbc.YdbParameterMetaData;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.YdbPreparedQuery;

public class YdbParameterMetaDataImpl
implements YdbParameterMetaData {
    private final YdbPreparedQuery params;

    public YdbParameterMetaDataImpl(YdbPreparedQuery params) {
        this.params = params;
    }

    @Override
    public int getParameterCount() {
        return this.params.parametersCount();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        TypeDescription description = this.params.getDescription(param);
        if (description == null) {
            return 2;
        }
        return description.isOptional() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int param) {
        return false;
    }

    @Override
    public int getPrecision(int param) {
        return 0;
    }

    @Override
    public int getScale(int param) {
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        TypeDescription description = this.params.getDescription(param);
        if (description == null) {
            return 1111;
        }
        return description.sqlType().getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        TypeDescription description = this.params.getDescription(param);
        if (description == null) {
            return null;
        }
        return description.ydbType().toString();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        TypeDescription description = this.params.getDescription(param);
        if (description == null) {
            return null;
        }
        return description.sqlType().getJavaType().getName();
    }

    @Override
    public int getParameterMode(int param) {
        return 1;
    }

    @Override
    public String getParameterName(int param) throws SQLException {
        return this.params.getNameByIndex(param);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

