/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import com.google.common.base.Strings;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ydb.core.Result;
import tech.ydb.core.StatusCode;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbDatabaseMetaData;
import tech.ydb.jdbc.YdbDriverInfo;
import tech.ydb.jdbc.common.FixedResultSetFactory;
import tech.ydb.jdbc.common.YdbFunctions;
import tech.ydb.jdbc.context.SchemeExecutor;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.impl.MetaDataTables;
import tech.ydb.jdbc.impl.YdbResultSetImpl;
import tech.ydb.jdbc.impl.YdbStatementImpl;
import tech.ydb.jdbc.impl.YdbTypes;
import tech.ydb.proto.scheme.SchemeOperationProtos;
import tech.ydb.scheme.description.ListDirectoryResult;
import tech.ydb.table.description.TableColumn;
import tech.ydb.table.description.TableDescription;
import tech.ydb.table.description.TableIndex;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.settings.DescribeTableSettings;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;

public class YdbDatabaseMetaDataImpl
implements YdbDatabaseMetaData {
    private static final Logger LOGGER = Logger.getLogger(YdbDatabaseMetaDataImpl.class.getName());
    static final String TABLE = "TABLE";
    static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private final YdbConnection connection;
    private final YdbValidator validator;
    private final SchemeExecutor executor;

    public YdbDatabaseMetaDataImpl(YdbConnection connection) {
        this.connection = Objects.requireNonNull(connection);
        this.executor = new SchemeExecutor(connection.getCtx());
        this.validator = new YdbValidator(LOGGER);
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.connection.getCtx().getUrl();
    }

    @Override
    public String getUserName() {
        String username = this.connection.getCtx().getUsername();
        return username != null ? username : "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "YDB";
    }

    @Override
    public String getDatabaseProductVersion() {
        return "unspecified";
    }

    @Override
    public String getDriverName() {
        return "YDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return YdbDriverInfo.DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return YdbDriverInfo.DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return YdbDriverInfo.DRIVER_MINOR_VERSION;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public String getNumericFunctions() {
        return YdbFunctions.NUMERIC_FUNCTIONS;
    }

    @Override
    public String getStringFunctions() {
        return YdbFunctions.STRING_FUNCTIONS;
    }

    @Override
    public String getSystemFunctions() {
        return YdbFunctions.SYSTEM_FUNCTIONS;
    }

    @Override
    public String getTimeDateFunctions() {
        return YdbFunctions.DATETIME_FUNCTIONS;
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "Database";
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return "Path";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return "/";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0x400000;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0x400000;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 255;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 200;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 20;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 200;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 200;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 200;
    }

    @Override
    public int getMaxConnections() {
        return 1000;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 255;
    }

    @Override
    public int getMaxIndexLength() {
        return 0x100000;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 255;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 255;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 255;
    }

    @Override
    public int getMaxRowSize() {
        return 0x400000;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 10240;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 255;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 255;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        switch (level) {
            case 8: 
            case 16: 
            case 17: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return true;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        return this.emptyResultSet(MetaDataTables.PROCEDURES);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        return this.emptyResultSet(MetaDataTables.PROCEDURE_COLUMNS);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean matchSystemTables;
        boolean matchTables;
        LOGGER.log(Level.FINE, "getTables, catalog=[{0}], schemaPattern=[{1}], tableNamePattern=[{2}], types={3}", new Object[]{catalog, schemaPattern, tableNamePattern, types == null ? "<null>" : Arrays.asList(types)});
        if (!this.isMatchedCatalog(catalog)) {
            return this.emptyResultSet(MetaDataTables.TABLES);
        }
        if (!this.isMatchedSchema(schemaPattern)) {
            return this.emptyResultSet(MetaDataTables.TABLES);
        }
        if (types == null) {
            matchTables = true;
            matchSystemTables = true;
        } else {
            HashSet<String> typesSet = new HashSet<String>(Arrays.asList(types));
            matchTables = typesSet.contains(TABLE);
            matchSystemTables = typesSet.contains(SYSTEM_TABLE);
        }
        if (!matchTables && !matchSystemTables) {
            return this.emptyResultSet(MetaDataTables.TABLES);
        }
        FixedResultSetFactory.ResultSetBuilder rs = MetaDataTables.TABLES.createResultSet();
        this.listTables(tableNamePattern).stream().map(x$0 -> new TableRecord((String)x$0)).filter(tr -> matchTables && !((TableRecord)tr).isSystem || matchSystemTables && ((TableRecord)tr).isSystem).sorted().forEach(tr -> rs.newRow().withTextValue("TABLE_NAME", ((TableRecord)tr).name).withTextValue("TABLE_TYPE", ((TableRecord)tr).isSystem ? SYSTEM_TABLE : TABLE).build());
        return this.resultSet(rs.build());
    }

    @Override
    public ResultSet getSchemas() {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() {
        return this.emptyResultSet(MetaDataTables.CATALOGS);
    }

    @Override
    public ResultSet getTableTypes() {
        ResultSetReader rs = MetaDataTables.TABLE_TYPES.createResultSet().newRow().withTextValue("TABLE_TYPE", TABLE).build().newRow().withTextValue("TABLE_TYPE", SYSTEM_TABLE).build().build();
        return this.resultSet(rs);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        LOGGER.log(Level.FINE, "getColumns, catalog=[{0}], schemaPattern=[{1}], tableNamePattern=[{2}], columnNamePattern=[{3}]", new Object[]{catalog, schemaPattern, tableNamePattern, columnNamePattern});
        if (!this.isMatchedCatalog(catalog)) {
            return this.emptyResultSet(MetaDataTables.COLUMNS);
        }
        if (!this.isMatchedSchema(schemaPattern)) {
            return this.emptyResultSet(MetaDataTables.COLUMNS);
        }
        Predicate<String> columnFilter = YdbDatabaseMetaDataImpl.equalsFilter(columnNamePattern);
        List<String> tableNames = this.listTables(tableNamePattern);
        Collections.sort(tableNames);
        FixedResultSetFactory.ResultSetBuilder rs = MetaDataTables.COLUMNS.createResultSet();
        for (String tableName : tableNames) {
            TableDescription tableDescription = this.describeTable(tableName);
            if (tableDescription == null) continue;
            int index = 0;
            for (TableColumn column : tableDescription.getColumns()) {
                int nullable;
                index = (short)(index + 1);
                if (!columnFilter.test(column.getName())) continue;
                Type type = column.getType();
                if (type.getKind() == Type.Kind.OPTIONAL) {
                    nullable = 1;
                    type = type.unwrapOptional();
                } else {
                    nullable = 0;
                }
                int decimalDigits = type.getKind() == Type.Kind.DECIMAL ? 22 : 0;
                rs.newRow().withTextValue("TABLE_NAME", tableName).withTextValue("COLUMN_NAME", column.getName()).withIntValue("DATA_TYPE", YdbTypes.toSqlType(type)).withTextValue("TYPE_NAME", type.toString()).withIntValue("COLUMN_SIZE", YdbTypes.getSqlPrecision(type)).withIntValue("BUFFER_LENGTH", 0).withIntValue("DECIMAL_DIGITS", decimalDigits).withIntValue("NUM_PREC_RADIX", 10).withIntValue("NULLABLE", nullable).withIntValue("SQL_DATA_TYPE", 0).withIntValue("SQL_DATETIME_SUB", 0).withIntValue("CHAR_OCTET_LENGTH", 0).withIntValue("ORDINAL_POSITION", index).withTextValue("IS_NULLABLE", "YES").withShortValue("SOURCE_DATA_TYPE", (short)0).withTextValue("IS_AUTOINCREMENT", "NO").withTextValue("IS_GENERATEDCOLUMN", "NO").build();
            }
        }
        return this.resultSet(rs.build());
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        return this.emptyResultSet(MetaDataTables.COLUMN_PRIVILEGES);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        return this.emptyResultSet(MetaDataTables.TABLE_PRIVILEGES);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        LOGGER.log(Level.FINE, "getBestRowIdentifier, catalog=[{0}], schema=[{1}], table=[{2}], scope=[{3}], nullable=[{4}]", new Object[]{catalog, schema, table, scope, nullable});
        if (!this.isMatchedCatalog(catalog)) {
            return this.emptyResultSet(MetaDataTables.BEST_ROW_IDENTIFIERS);
        }
        if (!this.isMatchedSchema(schema)) {
            return this.emptyResultSet(MetaDataTables.BEST_ROW_IDENTIFIERS);
        }
        if (YdbDatabaseMetaDataImpl.isMatchedAny(table)) {
            return this.emptyResultSet(MetaDataTables.BEST_ROW_IDENTIFIERS);
        }
        if (!nullable) {
            return this.emptyResultSet(MetaDataTables.BEST_ROW_IDENTIFIERS);
        }
        TableDescription description = this.describeTable(table);
        if (description == null) {
            return this.emptyResultSet(MetaDataTables.BEST_ROW_IDENTIFIERS);
        }
        FixedResultSetFactory.ResultSetBuilder rs = MetaDataTables.BEST_ROW_IDENTIFIERS.createResultSet();
        Map columnMap = description.getColumns().stream().collect(Collectors.toMap(TableColumn::getName, Function.identity()));
        for (String key : description.getPrimaryKeys()) {
            TableColumn column = (TableColumn)columnMap.get(key);
            Type type = column.getType();
            if (type.getKind() == Type.Kind.OPTIONAL) {
                type = type.unwrapOptional();
            }
            int decimalDigits = type.getKind() == Type.Kind.DECIMAL ? 22 : 0;
            rs.newRow().withShortValue("SCOPE", (short)scope).withTextValue("COLUMN_NAME", key).withIntValue("DATA_TYPE", YdbTypes.toSqlType(type)).withTextValue("TYPE_NAME", type.toString()).withIntValue("COLUMN_SIZE", 0).withIntValue("BUFFER_LENGTH", 0).withShortValue("DECIMAL_DIGITS", (short)decimalDigits).withShortValue("PSEUDO_COLUMN", (short)1).build();
        }
        return this.resultSet(rs.build());
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return this.emptyResultSet(MetaDataTables.VERSION_COLUMNS);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        LOGGER.log(Level.FINE, "getPrimaryKeys, catalog=[{0}], schema=[{1}], table=[{2}]", new Object[]{catalog, schema, table});
        if (!this.isMatchedCatalog(catalog)) {
            return this.emptyResultSet(MetaDataTables.PRIMARY_KEYS);
        }
        if (!this.isMatchedSchema(schema)) {
            return this.emptyResultSet(MetaDataTables.PRIMARY_KEYS);
        }
        if (YdbDatabaseMetaDataImpl.isMatchedAny(table)) {
            return this.emptyResultSet(MetaDataTables.PRIMARY_KEYS);
        }
        TableDescription description = this.describeTable(table);
        if (description == null) {
            return this.emptyResultSet(MetaDataTables.PRIMARY_KEYS);
        }
        FixedResultSetFactory.ResultSetBuilder rs = MetaDataTables.PRIMARY_KEYS.createResultSet();
        short index = 0;
        for (String key : description.getPrimaryKeys()) {
            index = (short)(index + 1);
            rs.newRow().withTextValue("TABLE_NAME", table).withTextValue("COLUMN_NAME", key).withShortValue("KEY_SEQ", index).build();
        }
        return this.resultSet(rs.build());
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return this.emptyResultSet(MetaDataTables.IMPORTED_KEYS);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        return this.emptyResultSet(MetaDataTables.EXPORTED_KEYS);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return this.emptyResultSet(MetaDataTables.CROSS_REFERENCES);
    }

    @Override
    public ResultSet getTypeInfo() {
        FixedResultSetFactory.ResultSetBuilder rs = MetaDataTables.TYPE_INFOS.createResultSet();
        for (Type type : YdbTypes.getAllDatabaseTypes()) {
            String literal = this.getLiteral(type);
            int scale = type.getKind() == Type.Kind.DECIMAL ? 9 : 0;
            rs.newRow().withTextValue("TYPE_NAME", type.toString()).withIntValue("DATA_TYPE", YdbTypes.toSqlType(type)).withIntValue("PRECISION", YdbTypes.getSqlPrecision(type)).withTextValue("LITERAL_PREFIX", literal).withTextValue("LITERAL_SUFFIX", literal).withShortValue("NULLABLE", (short)1).withBoolValue("CASE_SENSITIVE", true).withShortValue("SEARCHABLE", this.getSearchable(type)).withBoolValue("UNSIGNED_ATTRIBUTE", this.getUnsigned(type)).withBoolValue("FIXED_PREC_SCALE", type.getKind() == Type.Kind.DECIMAL).withBoolValue("AUTO_INCREMENT", false).withShortValue("MINIMUM_SCALE", (short)scale).withShortValue("MAXIMUM_SCALE", (short)scale).withIntValue("SQL_DATA_TYPE", 0).withIntValue("SQL_DATETIME_SUB", 0).withIntValue("NUM_PREC_RADIX", 10).build();
        }
        return this.resultSet(rs.build());
    }

    private short getSearchable(Type type) {
        if (type.getKind() == Type.Kind.PRIMITIVE) {
            switch ((PrimitiveType)type) {
                case Json: 
                case JsonDocument: 
                case Yson: {
                    return 0;
                }
                case Bytes: 
                case Text: {
                    return 3;
                }
            }
            return 2;
        }
        return 2;
    }

    private boolean getUnsigned(Type type) {
        if (type.getKind() == Type.Kind.PRIMITIVE) {
            switch ((PrimitiveType)type) {
                case Uint8: 
                case Uint16: 
                case Uint32: 
                case Uint64: {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private String getLiteral(Type type) {
        if (type.getKind() == Type.Kind.PRIMITIVE) {
            switch ((PrimitiveType)type) {
                case Json: 
                case JsonDocument: 
                case Yson: 
                case Bytes: 
                case Text: {
                    return "'";
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        LOGGER.log(Level.FINE, "getIndexInfo, catalog=[{0}], schema=[{1}], table=[{2}], unique=[{3}], approximate=[{4}]", new Object[]{catalog, schema, table, unique, approximate});
        if (!this.isMatchedCatalog(catalog)) {
            return this.emptyResultSet(MetaDataTables.INDEX_INFOS);
        }
        if (!this.isMatchedSchema(schema)) {
            return this.emptyResultSet(MetaDataTables.INDEX_INFOS);
        }
        if (YdbDatabaseMetaDataImpl.isMatchedAny(table)) {
            return this.emptyResultSet(MetaDataTables.INDEX_INFOS);
        }
        if (unique) {
            return this.emptyResultSet(MetaDataTables.INDEX_INFOS);
        }
        TableDescription description = this.describeTable(table);
        if (description == null) {
            return this.emptyResultSet(MetaDataTables.INDEX_INFOS);
        }
        FixedResultSetFactory.ResultSetBuilder rs = MetaDataTables.INDEX_INFOS.createResultSet();
        for (TableIndex tableIndex : description.getIndexes()) {
            short index = 0;
            for (String column : tableIndex.getColumns()) {
                index = (short)(index + 1);
                rs.newRow().withTextValue("TABLE_NAME", table).withBoolValue("NON_UNIQUE", true).withTextValue("INDEX_NAME", tableIndex.getName()).withShortValue("TYPE", (short)2).withShortValue("ORDINAL_POSITION", index).withTextValue("COLUMN_NAME", column).withLongValue("CARDINALITY", 0L).withLongValue("PAGES", 0L).build();
            }
        }
        return this.resultSet(rs.build());
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003 || type == 1004;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return (type == 1003 || type == 1004) && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        return this.emptyResultSet(MetaDataTables.UDTS);
    }

    @Override
    public YdbConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        return this.emptyResultSet(MetaDataTables.SUPER_TYPES);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        return this.emptyResultSet(MetaDataTables.SUPER_TABLES);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return this.emptyResultSet(MetaDataTables.ATTRIBUTES);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) {
        return this.emptyResultSet(MetaDataTables.SCHEMAS);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return this.emptyResultSet(MetaDataTables.CLIENT_INFO_PROPERTIES);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) {
        return this.emptyResultSet(MetaDataTables.FUNCTIONS);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        return this.emptyResultSet(MetaDataTables.FUNCTION_COLUMNS);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return this.emptyResultSet(MetaDataTables.PSEUDO_COLUMNS);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    private List<String> listTables(String tableNamePattern) throws SQLException {
        Predicate<String> filter = YdbDatabaseMetaDataImpl.equalsFilter(tableNamePattern);
        List<String> allTables = this.listTables(filter);
        LOGGER.log(Level.FINE, "Loaded {0} tables...", allTables.size());
        return allTables;
    }

    private List<String> listTables(Predicate<String> filter) throws SQLException {
        String databaseWithSuffix = YdbDatabaseMetaDataImpl.withSuffix(this.connection.getCtx().getDatabase());
        return this.tables(databaseWithSuffix, databaseWithSuffix, filter);
    }

    private List<String> tables(String databasePrefix, String path, Predicate<String> filter) throws SQLException {
        ListDirectoryResult result = (ListDirectoryResult)this.validator.call("List tables from " + path, () -> this.executor.listDirectory(path));
        ArrayList<String> tables = new ArrayList<String>();
        String pathPrefix = YdbDatabaseMetaDataImpl.withSuffix(path);
        for (SchemeOperationProtos.Entry entry : result.getChildren()) {
            String tableName = entry.getName();
            String fullPath = pathPrefix + tableName;
            String tablePath = fullPath.substring(databasePrefix.length());
            switch (entry.getType()) {
                case TABLE: 
                case COLUMN_TABLE: {
                    if (!filter.test(tablePath)) break;
                    tables.add(tablePath);
                    break;
                }
                case DIRECTORY: {
                    tables.addAll(this.tables(databasePrefix, fullPath, filter));
                    break;
                }
            }
        }
        return tables;
    }

    private TableDescription describeTable(String table) throws SQLException {
        DescribeTableSettings settings = this.connection.getCtx().withDefaultTimeout(new DescribeTableSettings());
        String databaseWithSuffix = YdbDatabaseMetaDataImpl.withSuffix(this.connection.getCtx().getDatabase());
        return (TableDescription)this.validator.call("Describe table " + table, () -> this.executor.describeTable(databaseWithSuffix + table, settings).thenApply(result -> {
            if (result.getStatus().getCode() == StatusCode.SCHEME_ERROR) {
                LOGGER.log(Level.WARNING, "Cannot describe table {0} -> {1}", new Object[]{table, result.getStatus()});
                return Result.success(null);
            }
            return result;
        }));
    }

    private ResultSet emptyResultSet(FixedResultSetFactory factory) {
        YdbStatementImpl statement = new YdbStatementImpl(this.connection, 1004);
        return new YdbResultSetImpl(statement, factory.createResultSet().build());
    }

    private ResultSet resultSet(ResultSetReader rsReader) {
        YdbStatementImpl statement = new YdbStatementImpl(this.connection, 1004);
        return new YdbResultSetImpl(statement, rsReader);
    }

    private boolean isMatchedCatalog(String catalog) {
        return YdbDatabaseMetaDataImpl.isMatchedAny(catalog);
    }

    private boolean isMatchedSchema(String schema) throws SQLException {
        return YdbDatabaseMetaDataImpl.isMatchedAny(schema) || Objects.equals(YdbDatabaseMetaDataImpl.withSuffix(schema), YdbDatabaseMetaDataImpl.withSuffix(this.connection.getSchema()));
    }

    private static boolean isMatchedAny(String filter) {
        return Strings.isNullOrEmpty((String)filter) || filter.equals("%");
    }

    private static Predicate<String> equalsFilter(String name) {
        if (YdbDatabaseMetaDataImpl.isMatchedAny(name)) {
            return table -> true;
        }
        return name::equals;
    }

    static String withSuffix(String prefix) {
        return prefix == null || prefix.endsWith("/") ? prefix : prefix + "/";
    }

    private class TableRecord
    implements Comparable<TableRecord> {
        private final boolean isSystem;
        private final String name;

        TableRecord(String name) {
            this.name = name;
            this.isSystem = name.startsWith(".sys/") || name.startsWith(".sys_health/") || name.startsWith(".sys_health_dev/");
        }

        @Override
        public int compareTo(TableRecord o) {
            if (this.isSystem != o.isSystem) {
                return this.isSystem ? 1 : -1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

