/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.util.List;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.query.ExplainedQuery;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;

public interface YdbExecutor {
    default public void ensureOpened() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    public boolean isClosed();

    public String txID();

    public int transactionLevel() throws SQLException;

    public boolean isInsideTransaction() throws SQLException;

    public boolean isAutoCommit() throws SQLException;

    public boolean isReadOnly() throws SQLException;

    public void setTransactionLevel(int var1) throws SQLException;

    public void setReadOnly(boolean var1) throws SQLException;

    public void setAutoCommit(boolean var1) throws SQLException;

    public void executeSchemeQuery(YdbContext var1, YdbValidator var2, String var3) throws SQLException;

    public List<ResultSetReader> executeDataQuery(YdbContext var1, YdbValidator var2, String var3, long var4, boolean var6, Params var7) throws SQLException;

    public ResultSetReader executeScanQuery(YdbContext var1, YdbValidator var2, String var3, Params var4) throws SQLException;

    public ExplainedQuery executeExplainQuery(YdbContext var1, YdbValidator var2, String var3) throws SQLException;

    public void commit(YdbContext var1, YdbValidator var2) throws SQLException;

    public void rollback(YdbContext var1, YdbValidator var2) throws SQLException;

    public boolean isValid(YdbValidator var1, int var2) throws SQLException;

    public void close();
}

