/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tech.ydb.core.Result;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.jdbc.YdbPrepareMode;
import tech.ydb.jdbc.context.QueryServiceExecutor;
import tech.ydb.jdbc.context.QueryStat;
import tech.ydb.jdbc.context.TableServiceExecutor;
import tech.ydb.jdbc.context.YdbExecutor;
import tech.ydb.jdbc.exception.ExceptionFactory;
import tech.ydb.jdbc.query.YdbPreparedQuery;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.query.params.BatchedQuery;
import tech.ydb.jdbc.query.params.InMemoryQuery;
import tech.ydb.jdbc.query.params.PreparedQuery;
import tech.ydb.jdbc.settings.YdbClientProperties;
import tech.ydb.jdbc.settings.YdbConfig;
import tech.ydb.jdbc.settings.YdbConnectionProperties;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.jdbc.settings.YdbQueryProperties;
import tech.ydb.query.QueryClient;
import tech.ydb.query.impl.QueryClientImpl;
import tech.ydb.scheme.SchemeClient;
import tech.ydb.table.Session;
import tech.ydb.table.SessionRetryContext;
import tech.ydb.table.SessionSupplier;
import tech.ydb.table.TableClient;
import tech.ydb.table.description.TableColumn;
import tech.ydb.table.description.TableDescription;
import tech.ydb.table.impl.PooledTableClient;
import tech.ydb.table.query.DataQuery;
import tech.ydb.table.query.ExplainDataQueryResult;
import tech.ydb.table.rpc.TableRpc;
import tech.ydb.table.rpc.grpc.GrpcTableRpc;
import tech.ydb.table.settings.DescribeTableSettings;
import tech.ydb.table.settings.ExplainDataQuerySettings;
import tech.ydb.table.settings.PrepareDataQuerySettings;
import tech.ydb.table.settings.RequestSettings;
import tech.ydb.table.values.Type;

public class YdbContext
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(YdbContext.class.getName());
    private static final int SESSION_POOL_RESIZE_STEP = 50;
    private static final int SESSION_POOL_RESIZE_THRESHOLD = 10;
    private final YdbConfig config;
    private final YdbOperationProperties operationProps;
    private final YdbQueryProperties queryOptions;
    private final GrpcTransport grpcTransport;
    private final PooledTableClient tableClient;
    private final QueryClientImpl queryClient;
    private final SchemeClient schemeClient;
    private final SessionRetryContext retryCtx;
    private final Cache<String, YdbQuery> queriesCache;
    private final Cache<String, QueryStat> queryStatesCache;
    private final Cache<String, Map<String, Type>> queryParamsCache;
    private final boolean autoResizeSessionPool;
    private final AtomicInteger connectionsCount = new AtomicInteger();

    private YdbContext(YdbConfig config, YdbOperationProperties operationProperties, YdbQueryProperties queryProperties, GrpcTransport transport, PooledTableClient tableClient, QueryClientImpl queryClient, boolean autoResize) {
        this.config = config;
        this.operationProps = operationProperties;
        this.queryOptions = queryProperties;
        this.autoResizeSessionPool = autoResize;
        this.grpcTransport = transport;
        this.tableClient = tableClient;
        this.queryClient = queryClient;
        this.schemeClient = SchemeClient.newClient((GrpcTransport)transport).build();
        this.retryCtx = SessionRetryContext.create((SessionSupplier)tableClient).build();
        int cacheSize = config.getPreparedStatementsCachecSize();
        if (cacheSize > 0) {
            this.queriesCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
            this.queryParamsCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
            this.queryStatesCache = config.isFullScanDetectorEnabled() ? CacheBuilder.newBuilder().maximumSize((long)cacheSize).build() : null;
        } else {
            this.queriesCache = null;
            this.queryStatesCache = null;
            this.queryParamsCache = null;
        }
    }

    public GrpcTransport getGrpcTransport() {
        return this.grpcTransport;
    }

    public String getDatabase() {
        return this.grpcTransport.getDatabase();
    }

    public SchemeClient getSchemeClient() {
        return this.schemeClient;
    }

    public TableClient getTableClient() {
        return this.tableClient;
    }

    public QueryClient getQueryClient() {
        return this.queryClient;
    }

    public String getUrl() {
        return this.config.getUrl();
    }

    public String getUsername() {
        return this.config.getUsername();
    }

    public YdbExecutor createExecutor() throws SQLException {
        if (this.config.isUseQueryService()) {
            return new QueryServiceExecutor(this, this.operationProps.getTransactionLevel(), this.operationProps.isAutoCommit());
        }
        return new TableServiceExecutor(this, this.operationProps.getTransactionLevel(), this.operationProps.isAutoCommit());
    }

    public int getConnectionsCount() {
        return this.connectionsCount.get();
    }

    public YdbOperationProperties getOperationProperties() {
        return this.operationProps;
    }

    @Override
    public void close() {
        try {
            this.schemeClient.close();
            this.queryClient.close();
            this.tableClient.close();
            this.grpcTransport.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to close client: " + e.getMessage(), e);
        }
    }

    public boolean hasConnections() {
        return this.connectionsCount.get() > 0;
    }

    public boolean queryStatsEnabled() {
        return this.queryStatesCache != null;
    }

    public Collection<QueryStat> getQueryStats() {
        if (this.queryStatesCache == null) {
            return Collections.emptyList();
        }
        TreeSet<QueryStat> sortedByUsage = new TreeSet<QueryStat>(Comparator.comparingLong(QueryStat::getUsageCounter).reversed());
        sortedByUsage.addAll(this.queryStatesCache.asMap().values());
        return sortedByUsage;
    }

    public void traceQueryExecution(YdbQuery query) {
        QueryStat stat;
        if (this.queryStatesCache != null && (stat = (QueryStat)this.queryStatesCache.getIfPresent((Object)query.getOriginQuery())) != null) {
            stat.incrementUsage();
        }
    }

    public void register() {
        int actual = this.connectionsCount.incrementAndGet();
        int maxSize = this.tableClient.sessionPoolStats().getMaxSize();
        if (this.autoResizeSessionPool && actual > maxSize - 10) {
            int newSize = maxSize + 50;
            if (maxSize == this.tableClient.sessionPoolStats().getMaxSize()) {
                this.tableClient.updatePoolMaxSize(newSize);
            }
        }
    }

    public void deregister() {
        int actual = this.connectionsCount.decrementAndGet();
        int maxSize = this.tableClient.sessionPoolStats().getMaxSize();
        if (this.autoResizeSessionPool && maxSize > 50 && actual < maxSize - 50 - 20) {
            int newSize = maxSize - 50;
            if (maxSize == this.tableClient.sessionPoolStats().getMaxSize()) {
                this.tableClient.updatePoolMaxSize(newSize);
            }
        }
    }

    public static YdbContext createContext(YdbConfig config) throws SQLException {
        try {
            LOGGER.log(Level.INFO, "Creating new YDB connection to {0}", config.getConnectionString());
            YdbConnectionProperties connProps = new YdbConnectionProperties(config);
            YdbClientProperties clientProps = new YdbClientProperties(config);
            YdbOperationProperties operationProps = new YdbOperationProperties(config);
            YdbQueryProperties queryProps = new YdbQueryProperties(config);
            GrpcTransportBuilder builder = GrpcTransport.forConnectionString((String)config.getConnectionString());
            connProps.applyToGrpcTransport(builder);
            builder.withSchedulerFactory(() -> {
                String namePrefix = "ydb-jdbc-scheduler[" + config.hashCode() + "]-thread-";
                AtomicInteger threadNumber = new AtomicInteger(1);
                return Executors.newScheduledThreadPool(2, r -> {
                    Thread t = new Thread(r, namePrefix + threadNumber.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                });
            });
            GrpcTransport grpcTransport = builder.build();
            PooledTableClient.Builder tableClient = PooledTableClient.newClient((TableRpc)GrpcTableRpc.useTransport((GrpcTransport)grpcTransport));
            QueryClientImpl.Builder queryClient = QueryClientImpl.newClient((GrpcTransport)grpcTransport);
            boolean autoResize = clientProps.applyToTableClient((TableClient.Builder)tableClient, (QueryClient.Builder)queryClient);
            return new YdbContext(config, operationProps, queryProps, grpcTransport, tableClient.build(), queryClient.build(), autoResize);
        }
        catch (RuntimeException ex) {
            StringBuilder sb = new StringBuilder("Cannot connect to YDB: ").append(ex.getMessage());
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                sb.append(", ").append(cause.getMessage());
            }
            throw new SQLException(sb.toString(), ex);
        }
    }

    public <T extends RequestSettings<?>> T withDefaultTimeout(T settings) {
        Duration operation = this.operationProps.getDeadlineTimeout();
        if (!operation.isZero() && !operation.isNegative()) {
            settings.setOperationTimeout(operation);
            settings.setTimeout(operation.plusSeconds(1L));
        }
        return settings;
    }

    public <T extends BaseRequestSettings.BaseBuilder<T>> T withRequestTimeout(T builder) {
        Duration operation = this.operationProps.getDeadlineTimeout();
        if (operation.isNegative() || operation.isZero()) {
            return builder;
        }
        return (T)builder.withRequestTimeout(operation);
    }

    public YdbQuery parseYdbQuery(String sql) throws SQLException {
        return YdbQuery.parseQuery(sql, this.queryOptions);
    }

    public YdbQuery findOrParseYdbQuery(String sql) throws SQLException {
        QueryStat stat;
        if (this.queriesCache == null) {
            return this.parseYdbQuery(sql);
        }
        YdbQuery cached = (YdbQuery)this.queriesCache.getIfPresent((Object)sql);
        if (cached == null) {
            cached = this.parseYdbQuery(sql);
            this.queriesCache.put((Object)sql, (Object)cached);
        }
        if (this.queryStatesCache != null && (stat = (QueryStat)this.queryStatesCache.getIfPresent((Object)sql)) == null) {
            ExplainDataQuerySettings settings;
            String preparedYQL = cached.getPreparedYql();
            Result res = (Result)this.retryCtx.supplyResult(arg_0 -> YdbContext.lambda$findOrParseYdbQuery$2(preparedYQL, settings = this.withDefaultTimeout(new ExplainDataQuerySettings()), arg_0)).join();
            if (res.isSuccess()) {
                ExplainDataQueryResult exp = (ExplainDataQueryResult)res.getValue();
                stat = new QueryStat(cached, exp.getQueryAst(), exp.getQueryPlan());
            } else {
                stat = new QueryStat(cached, res.getStatus());
            }
            this.queryStatesCache.put((Object)sql, (Object)stat);
        }
        return cached;
    }

    public YdbPreparedQuery findOrPrepareParams(YdbQuery query, YdbPrepareMode mode) throws SQLException {
        Map<String, Type> types;
        if (query.getYqlBatcher() != null && mode == YdbPrepareMode.AUTO) {
            BatchedQuery params;
            DescribeTableSettings settings;
            String tableName;
            String tablePath;
            Result result;
            types = (Map<String, Type>)this.queryParamsCache.getIfPresent((Object)query.getOriginQuery());
            if (types == null && (result = (Result)this.retryCtx.supplyResult(arg_0 -> YdbContext.lambda$findOrPrepareParams$3(tablePath = (tableName = query.getYqlBatcher().getTableName()).startsWith("/") ? tableName : this.getDatabase() + "/" + tableName, settings = this.withDefaultTimeout(new DescribeTableSettings()), arg_0)).join()).isSuccess()) {
                TableDescription descrtiption = (TableDescription)result.getValue();
                types = descrtiption.getColumns().stream().collect(Collectors.toMap(TableColumn::getName, TableColumn::getType));
                this.queryParamsCache.put((Object)query.getOriginQuery(), types);
            }
            if (types != null && (params = BatchedQuery.createAutoBatched(query.getYqlBatcher(), types)) != null) {
                return params;
            }
        }
        if (!query.isPlainYQL() || mode == YdbPrepareMode.IN_MEMORY || !this.queryOptions.isPrepareDataQueries()) {
            return new InMemoryQuery(query, this.queryOptions.isDeclareJdbcParameters());
        }
        try {
            boolean requireBatch;
            types = (Map)this.queryParamsCache.getIfPresent((Object)query.getOriginQuery());
            if (types == null) {
                String yql = query.getPreparedYql();
                PrepareDataQuerySettings settings = this.withDefaultTimeout(new PrepareDataQuerySettings());
                types = ((DataQuery)((Result)this.retryCtx.supplyResult(session -> session.prepareDataQuery(yql, settings)).join()).getValue()).types();
                this.queryParamsCache.put((Object)query.getOriginQuery(), (Object)types);
            }
            boolean bl = requireBatch = mode == YdbPrepareMode.DATA_QUERY_BATCH;
            if (requireBatch || mode == YdbPrepareMode.AUTO && this.queryOptions.isDetectBatchQueries()) {
                BatchedQuery params = BatchedQuery.tryCreateBatched(query, types);
                if (params != null) {
                    return params;
                }
                if (requireBatch) {
                    throw new SQLDataException("Statement cannot be executed as batch statement: " + query.getOriginQuery());
                }
            }
            return new PreparedQuery(query, types);
        }
        catch (UnexpectedResultException ex) {
            throw ExceptionFactory.createException("Cannot prepare data query: " + ex.getMessage(), ex);
        }
    }

    private static /* synthetic */ CompletableFuture lambda$findOrPrepareParams$3(String tablePath, DescribeTableSettings settings, Session session) {
        return session.describeTable(tablePath, settings);
    }

    private static /* synthetic */ CompletableFuture lambda$findOrParseYdbQuery$2(String preparedYQL, ExplainDataQuerySettings settings, Session session) {
        return session.explainDataQuery(preparedYQL, settings);
    }
}

