/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Optional;

public class YdbLookup {
    private static final String FILE_REF = "file:";
    private static final String CLASSPATH_REF = "classpath:";
    private static final String HOME_REF = "~/";
    private static final String FILE_HOME_REF = "file:~/";

    private YdbLookup() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileAsString(String name, String value) throws SQLException {
        try (InputStreamReader reader = new InputStreamReader(YdbLookup.readFile(name, value));){
            String string = CharStreams.toString((Readable)reader).trim();
            return string;
        }
        catch (IOException e) {
            String msg = String.format("Cannot process value %s for option %s: %s", value, name, e.getMessage());
            throw new SQLException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFileAsBytes(String name, String value) throws SQLException {
        try (InputStream is = YdbLookup.readFile(name, value);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            String msg = String.format("Cannot process value %s for option %s: %s", value, name, e.getMessage());
            throw new SQLException(msg);
        }
    }

    private static InputStream readFile(String name, String value) throws SQLException, IOException {
        if (value == null || value.trim().isEmpty()) {
            throw new SQLException("Missing value for option " + name);
        }
        String path = value.trim();
        if (path.toLowerCase().startsWith(CLASSPATH_REF)) {
            URL resource = ClassLoader.getSystemResource(path.substring(CLASSPATH_REF.length()));
            if (resource == null) {
                String msg = String.format("Cannot process value %s for option %s: %s", value, name, "resource not found");
                throw new SQLException(msg);
            }
            return resource.openStream();
        }
        if (path.toLowerCase().startsWith(FILE_REF)) {
            path = path.substring(FILE_REF.length());
        }
        if (path.startsWith(HOME_REF)) {
            String home = System.getProperty("user.home");
            path = path.substring(HOME_REF.length() - 1) + home;
        }
        return new FileInputStream(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stringFileReference(String ref) {
        Optional<URL> urlOpt = YdbLookup.resolvePath(ref);
        if (!urlOpt.isPresent()) return ref;
        URL url = urlOpt.get();
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            String string = CharStreams.toString((Readable)reader).trim();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read resource from " + url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] byteFileReference(String ref) {
        Optional<URL> urlOpt = YdbLookup.resolvePath(ref);
        if (!urlOpt.isPresent()) throw new RuntimeException("Must be 'file:' or 'classpath:' reference");
        URL url = urlOpt.get();
        try (InputStream stream = url.openStream();){
            byte[] byArray = ByteStreams.toByteArray((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read resource from " + url, e);
        }
    }

    static Optional<URL> resolvePath(String ref) {
        if (ref.startsWith(HOME_REF) || ref.startsWith(FILE_HOME_REF)) {
            try {
                String home = System.getProperty("user.home");
                String fixedRef = ref.startsWith(HOME_REF) ? ref.substring(HOME_REF.length() - 1) : ref.substring(FILE_HOME_REF.length() - 1);
                return Optional.of(new URL(FILE_REF + home + fixedRef));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to parse ref from home: " + ref, e);
            }
        }
        if (ref.startsWith(FILE_REF)) {
            try {
                return Optional.of(new URL(ref));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to parse ref as file: " + ref, e);
            }
        }
        if (ref.startsWith(CLASSPATH_REF)) {
            URL systemResource = ClassLoader.getSystemResource(ref.substring(CLASSPATH_REF.length()));
            if (systemResource == null) {
                throw new RuntimeException("Unable to find classpath resource: " + ref);
            }
            return Optional.of(systemResource);
        }
        return Optional.empty();
    }
}

