/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.auth.TokenAuthProvider;
import tech.ydb.auth.iam.CloudAuthHelper;
import tech.ydb.core.auth.StaticCredentials;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.jdbc.YdbDriver;
import tech.ydb.jdbc.settings.YdbConfig;
import tech.ydb.jdbc.settings.YdbProperty;
import tech.ydb.jdbc.settings.YdbValue;

public class YdbConnectionProperties {
    private static final Logger LOGGER = Logger.getLogger(YdbDriver.class.getName());
    static final YdbProperty<String> TOKEN = YdbProperty.content("token", "Authentication token");
    static final YdbProperty<String> TOKEN_FILE = YdbProperty.file("tokenFile", "Path to token file for the token-based authentication");
    static final YdbProperty<String> LOCAL_DATACENTER = YdbProperty.string("localDatacenter", "Local Datacenter");
    static final YdbProperty<Boolean> USE_SECURE_CONNECTION = YdbProperty.bool("secureConnection", "Use TLS connection");
    static final YdbProperty<byte[]> SECURE_CONNECTION_CERTIFICATE = YdbProperty.fileBytes("secureConnectionCertificate", "Use TLS connection with certificate from provided path");
    @Deprecated
    static final YdbProperty<String> SERVICE_ACCOUNT_FILE = YdbProperty.content("saFile", "Service account file based authentication");
    static final YdbProperty<String> SA_KEY_FILE = YdbProperty.file("saKeyFile", "Path to key file for the service account authentication");
    static final YdbProperty<Boolean> USE_METADATA = YdbProperty.bool("useMetadata", "Use metadata service for authentication");
    static final YdbProperty<String> IAM_ENDPOINT = YdbProperty.content("iamEndpoint", "Custom IAM endpoint for the service account authentication");
    static final YdbProperty<String> METADATA_URL = YdbProperty.content("metadataURL", "Custom URL for the metadata service authentication");
    private final String username;
    private final String password;
    private final YdbValue<String> localDatacenter;
    private final YdbValue<Boolean> useSecureConnection;
    private final YdbValue<byte[]> secureConnectionCertificate;
    private final YdbValue<String> token;
    private final YdbValue<String> tokenFile;
    private final YdbValue<String> serviceAccountFile;
    private final YdbValue<String> saKeyFile;
    private final YdbValue<Boolean> useMetadata;
    private final YdbValue<String> iamEndpoint;
    private final YdbValue<String> metadataUrl;

    public YdbConnectionProperties(YdbConfig config) throws SQLException {
        this.username = config.getUsername();
        this.password = config.getPassword();
        Properties props = config.getProperties();
        this.localDatacenter = LOCAL_DATACENTER.readValue(props);
        this.useSecureConnection = USE_SECURE_CONNECTION.readValue(props);
        this.secureConnectionCertificate = SECURE_CONNECTION_CERTIFICATE.readValue(props);
        this.token = TOKEN.readValue(props);
        this.tokenFile = TOKEN_FILE.readValue(props);
        this.serviceAccountFile = SERVICE_ACCOUNT_FILE.readValue(props);
        this.saKeyFile = SA_KEY_FILE.readValue(props);
        this.useMetadata = USE_METADATA.readValue(props);
        this.iamEndpoint = IAM_ENDPOINT.readValue(props);
        this.metadataUrl = METADATA_URL.readValue(props);
    }

    String getLocalDataCenter() {
        return this.localDatacenter.getValue();
    }

    String getToken() {
        return this.token.getValue();
    }

    byte[] getSecureConnectionCert() {
        return this.secureConnectionCertificate.getValue();
    }

    public GrpcTransportBuilder applyToGrpcTransport(GrpcTransportBuilder builder) {
        String endpoint;
        String json;
        if (this.localDatacenter.hasValue()) {
            builder = builder.withBalancingSettings(BalancingSettings.fromLocation((String)this.localDatacenter.getValue()));
        }
        if (this.useSecureConnection.hasValue() && this.useSecureConnection.getValue().booleanValue()) {
            builder = builder.withSecureConnection();
        }
        if (this.secureConnectionCertificate.hasValue()) {
            builder = builder.withSecureConnection(this.secureConnectionCertificate.getValue());
        }
        String usedProvider = null;
        if (this.username != null && !this.username.isEmpty()) {
            builder = builder.withAuthProvider((AuthRpcProvider)new StaticCredentials(this.username, this.password));
            usedProvider = "username & password credentials";
        }
        if (this.useMetadata.hasValue()) {
            if (usedProvider != null) {
                LOGGER.log(Level.WARNING, "Dublicate authentication config! Metadata credentials replaces {0}", usedProvider);
            }
            if (this.metadataUrl.hasValue()) {
                String url = this.metadataUrl.getValue();
                builder = builder.withAuthProvider((AuthRpcProvider)CloudAuthHelper.getMetadataAuthProvider((String)url));
            } else {
                builder = builder.withAuthProvider((AuthRpcProvider)CloudAuthHelper.getMetadataAuthProvider());
            }
            usedProvider = "metadata credentials";
        }
        if (this.tokenFile.hasValue()) {
            if (usedProvider != null) {
                LOGGER.log(Level.WARNING, "Dublicate authentication config! Token credentials replaces {0}", usedProvider);
            }
            builder = builder.withAuthProvider((AuthRpcProvider)new TokenAuthProvider(this.tokenFile.getValue()));
            usedProvider = "token file credentitals";
        }
        if (this.token.hasValue()) {
            if (usedProvider != null) {
                LOGGER.log(Level.WARNING, "Dublicate authentication config! Token credentials replaces {0}", usedProvider);
            }
            builder = builder.withAuthProvider((AuthRpcProvider)new TokenAuthProvider(this.token.getValue()));
            usedProvider = "token value credentitals";
        }
        if (this.saKeyFile.hasValue()) {
            if (usedProvider != null) {
                LOGGER.log(Level.WARNING, "Dublicate authentication config! Token credentials replaces {0}", usedProvider);
            }
            json = this.saKeyFile.getValue();
            if (this.iamEndpoint.hasValue()) {
                endpoint = this.iamEndpoint.getValue();
                builder = builder.withAuthProvider((AuthRpcProvider)CloudAuthHelper.getServiceAccountJsonAuthProvider((String)json, (String)endpoint));
            } else {
                builder = builder.withAuthProvider((AuthRpcProvider)CloudAuthHelper.getServiceAccountJsonAuthProvider((String)json));
            }
            builder = builder.withAuthProvider((AuthRpcProvider)new TokenAuthProvider(this.token.getValue()));
            usedProvider = "service account credentitals";
        }
        if (this.serviceAccountFile.hasValue()) {
            LOGGER.warning("Option 'saFile' is deprecated and will be removed in next versions. Use options 'saKeyFile' instead");
            if (usedProvider != null) {
                LOGGER.log(Level.WARNING, "Dublicate authentication config! Token credentials replaces {0}", usedProvider);
            }
            json = this.serviceAccountFile.getValue();
            if (this.iamEndpoint.hasValue()) {
                endpoint = this.iamEndpoint.getValue();
                builder = builder.withAuthProvider((AuthRpcProvider)CloudAuthHelper.getServiceAccountJsonAuthProvider((String)json, (String)endpoint));
            } else {
                builder = builder.withAuthProvider((AuthRpcProvider)CloudAuthHelper.getServiceAccountJsonAuthProvider((String)json));
            }
        }
        return builder;
    }
}

