/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.ParamDescription;
import tech.ydb.jdbc.query.YdbPreparedQuery;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.query.YqlBatcher;
import tech.ydb.jdbc.query.params.ValueFactory;
import tech.ydb.table.description.TableColumn;
import tech.ydb.table.description.TableDescription;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.ListType;
import tech.ydb.table.values.ListValue;
import tech.ydb.table.values.StructType;
import tech.ydb.table.values.StructValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class BatchedQuery
implements YdbPreparedQuery {
    private final String yql;
    private final String batchParamName;
    private final Map<String, ParamDescription> paramsByName;
    private final ParamDescription[] params;
    private final List<StructValue> batchList = new ArrayList<StructValue>();
    private final Map<String, Value<?>> currentValues = new HashMap();

    protected BatchedQuery(String yql, String listName, List<String> paramNames, Map<String, Type> types) throws SQLException {
        this.yql = yql;
        this.batchParamName = listName;
        this.paramsByName = new HashMap<String, ParamDescription>();
        this.params = new ParamDescription[paramNames.size()];
        for (int idx = 0; idx < paramNames.size(); ++idx) {
            ParamDescription desc;
            String name = paramNames.get(idx);
            if (!types.containsKey(name)) {
                throw new SQLException("Cannot prepared batch request: cannot find a column" + name);
            }
            TypeDescription type = TypeDescription.of(types.get(name));
            this.params[idx] = desc = new ParamDescription(name, "$" + name, type);
            this.paramsByName.put(name, desc);
        }
    }

    @Override
    public String getQueryText(Params prms) {
        return this.yql;
    }

    @Override
    public int parametersCount() {
        return this.params.length;
    }

    @Override
    public int batchSize() {
        return this.batchList.size();
    }

    @Override
    public void clearParameters() {
        this.currentValues.clear();
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchList.add(this.getCurrentValues());
        this.currentValues.clear();
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    protected StructValue getCurrentValues() throws SQLException {
        for (ParamDescription prm : this.params) {
            if (this.currentValues.containsKey(prm.name())) continue;
            if (prm.type().isOptional()) {
                this.currentValues.put(prm.name(), (Value<?>)prm.type().nullValue());
                continue;
            }
            throw new SQLDataException("Missing value for parameter: " + prm.displayName());
        }
        return StructValue.of(this.currentValues);
    }

    protected List<StructValue> getBatchedValues() {
        return this.batchList;
    }

    @Override
    public Params getCurrentParams() throws SQLException {
        ListValue list = ListValue.of((Value)this.getCurrentValues());
        return Params.of((String)this.batchParamName, (Value)list);
    }

    @Override
    public List<Params> getBatchParams() {
        if (this.batchList.isEmpty()) {
            return Collections.emptyList();
        }
        Value[] batchStructs = this.batchList.toArray(new Value[0]);
        ListValue list = ListValue.of((Value[])batchStructs);
        return Collections.singletonList(Params.of((String)this.batchParamName, (Value)list));
    }

    @Override
    public void setParam(int index, Object obj, int sqlType) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        ParamDescription desc = this.params[index - 1];
        Value<?> value = ValueFactory.readValue(desc.displayName(), obj, desc.type());
        this.currentValues.put(desc.name(), value);
    }

    @Override
    public void setParam(String name, Object obj, int sqlType) throws SQLException {
        if (!this.paramsByName.containsKey(name)) {
            throw new SQLException("Parameter not found: " + name);
        }
        ParamDescription desc = this.paramsByName.get(name);
        Value<?> value = ValueFactory.readValue(desc.displayName(), obj, desc.type());
        this.currentValues.put(desc.name(), value);
    }

    @Override
    public String getNameByIndex(int index) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.params[index - 1].name();
    }

    @Override
    public TypeDescription getDescription(int index) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.params[index - 1].type();
    }

    public static BatchedQuery tryCreateBatched(YdbQuery query, Map<String, Type> preparedTypes) throws SQLException {
        if (preparedTypes.size() != 1) {
            return null;
        }
        String listName = preparedTypes.keySet().iterator().next();
        Type type = preparedTypes.get(listName);
        if (type.getKind() != Type.Kind.LIST) {
            return null;
        }
        ListType listType = (ListType)type;
        Type innerType = listType.getItemType();
        if (innerType.getKind() != Type.Kind.STRUCT) {
            return null;
        }
        StructType itemType = (StructType)innerType;
        String[] columns = new String[itemType.getMembersCount()];
        HashMap<String, Type> types = new HashMap<String, Type>();
        for (int idx = 0; idx < itemType.getMembersCount(); ++idx) {
            types.put(itemType.getMemberName(idx), itemType.getMemberType(idx));
        }
        HashSet<String> indexedNames = new HashSet<String>();
        for (int idx = 0; idx < itemType.getMembersCount(); ++idx) {
            String indexedName = "p" + (1 + idx);
            if (!types.containsKey(indexedName)) continue;
            columns[idx] = indexedName;
            indexedNames.add(indexedName);
        }
        Iterator sortedIter = new TreeSet(types.keySet()).iterator();
        for (int idx = 0; idx < columns.length; ++idx) {
            if (columns[idx] != null) continue;
            String param = (String)sortedIter.next();
            while (indexedNames.contains(param)) {
                param = (String)sortedIter.next();
            }
            columns[idx] = param;
        }
        return new BatchedQuery(query.getPreparedYql(), listName, Arrays.asList(columns), types);
    }

    public static BatchedQuery createAutoBatched(YqlBatcher batcher, TableDescription description) throws SQLException {
        if (batcher.getCommand() == YqlBatcher.Cmd.DELETE || batcher.getCommand() == YqlBatcher.Cmd.UPDATE) {
            HashSet primaryKey = new HashSet(description.getPrimaryKeys());
            for (String keyColumn : batcher.getKeyColumns()) {
                if (primaryKey.remove(keyColumn)) continue;
                return null;
            }
            if (!primaryKey.isEmpty()) {
                return null;
            }
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Type> columnTypes = new HashMap<String, Type>();
        HashMap<String, Type> structTypes = new HashMap<String, Type>();
        ArrayList<String> columns = new ArrayList<String>();
        for (TableColumn column : description.getColumns()) {
            columnTypes.put(column.getName(), column.getType());
        }
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(batcher.getColumns());
        params.addAll(batcher.getKeyColumns());
        sb.append("DECLARE $batch AS List<Struct<");
        int idx = 1;
        for (String column : params) {
            Type type = (Type)columnTypes.get(column);
            if (type == null) {
                return null;
            }
            if (idx > 1) {
                sb.append(", ");
            }
            sb.append("p").append(idx).append(":").append(type.toString());
            structTypes.put("p" + idx, type);
            columns.add("p" + idx);
            ++idx;
        }
        sb.append(">>;\n");
        switch (batcher.getCommand()) {
            case UPSERT: {
                sb.append("UPSERT INTO `").append(batcher.getTableName()).append("` SELECT ");
                break;
            }
            case INSERT: {
                sb.append("INSERT INTO `").append(batcher.getTableName()).append("` SELECT ");
                break;
            }
            case REPLACE: {
                sb.append("REPLACE INTO `").append(batcher.getTableName()).append("` SELECT ");
                break;
            }
            case UPDATE: {
                sb.append("UPDATE `").append(batcher.getTableName()).append("` ON SELECT ");
                break;
            }
            case DELETE: {
                sb.append("DELETE FROM `").append(batcher.getTableName()).append("` ON SELECT ");
                break;
            }
            default: {
                return null;
            }
        }
        idx = 1;
        for (String column : params) {
            if (idx > 1) {
                sb.append(", ");
            }
            sb.append("p").append(idx).append(" AS `").append(column).append("`");
            ++idx;
        }
        sb.append(" FROM AS_TABLE($batch);");
        return new BatchedQuery(sb.toString(), "$batch", columns, structTypes);
    }
}

