/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.sql.SQLException;
import java.util.List;
import tech.ydb.jdbc.query.QueryCmd;
import tech.ydb.jdbc.query.QueryStatement;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQueryParser;
import tech.ydb.jdbc.query.YqlBatcher;
import tech.ydb.jdbc.settings.YdbQueryProperties;

public class YdbQuery {
    private final String originQuery;
    private final String preparedYQL;
    private final List<QueryStatement> statements;
    private final YqlBatcher batcher;
    private final QueryType type;
    private final boolean isPlainYQL;

    YdbQuery(String originQuery, String preparedYQL, List<QueryStatement> stats, YqlBatcher batcher, QueryType type) {
        this.originQuery = originQuery;
        this.preparedYQL = preparedYQL;
        this.statements = stats;
        this.type = type;
        this.batcher = batcher;
        boolean hasJdbcParamters = false;
        for (QueryStatement st : this.statements) {
            hasJdbcParamters = hasJdbcParamters || !st.getParams().isEmpty();
        }
        this.isPlainYQL = !hasJdbcParamters;
    }

    public QueryType getType() {
        return this.type;
    }

    public YqlBatcher getYqlBatcher() {
        return this.batcher.isValidBatch() ? this.batcher : null;
    }

    public boolean isPlainYQL() {
        return this.isPlainYQL;
    }

    public String getOriginQuery() {
        return this.originQuery;
    }

    public String getPreparedYql() {
        return this.preparedYQL;
    }

    public List<QueryStatement> getStatements() {
        return this.statements;
    }

    public static YdbQuery parseQuery(String query, YdbQueryProperties opts) throws SQLException {
        YdbQueryParser parser = new YdbQueryParser(opts.isDetectQueryType(), opts.isDetectJdbcParameters());
        String preparedYQL = parser.parseSQL(query);
        QueryType type = null;
        YqlBatcher batcher = parser.getYqlBatcher();
        List<QueryStatement> statements = parser.getStatements();
        if (batcher.isValidBatch()) {
            if (batcher.getCommand() == YqlBatcher.Cmd.INSERT && opts.isReplaceInsertToUpsert()) {
                batcher.setForcedUpsert();
            }
            if (batcher.getCommand() == YqlBatcher.Cmd.UPSERT && opts.isForceBulkUpsert()) {
                type = QueryType.BULK_QUERY;
            }
        } else if (opts.isForceScanSelect() && statements.size() == 1 && statements.get(0).getCmd() == QueryCmd.SELECT && parser.detectQueryType() == QueryType.DATA_QUERY) {
            type = QueryType.SCAN_QUERY;
        }
        if (type == null) {
            type = parser.detectQueryType();
        }
        return new YdbQuery(query, preparedYQL, statements, batcher, type);
    }
}

