/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.SQLException;
import tech.ydb.jdbc.YdbResultSetMetaData;
import tech.ydb.jdbc.common.ColumnInfo;
import tech.ydb.jdbc.impl.BaseYdbResultSet;
import tech.ydb.table.values.Type;

public class YdbResultSetMetaDataImpl
implements YdbResultSetMetaData {
    private final BaseYdbResultSet rs;

    public YdbResultSetMetaDataImpl(BaseYdbResultSet rs) {
        this.rs = rs;
    }

    @Override
    public int getColumnCount() {
        return this.rs.getColumnsLength();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        ColumnInfo info = this.rs.getColumnInfo(column);
        return info.isOptional() || info.isNull() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.rs.getColumnInfo(column).getName();
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public int getPrecision(int column) {
        return 0;
    }

    @Override
    public int getScale(int column) {
        return 0;
    }

    @Override
    public String getTableName(int column) {
        return "";
    }

    @Override
    public String getCatalogName(int column) {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.rs.getColumnInfo(column).getSqlType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.rs.getColumnInfo(column).getYdbType().toString();
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.rs.getColumnInfo(column).getSqlType().getJavaType().getName();
    }

    @Override
    public Type getYdbType(int column) throws SQLException {
        return this.rs.getColumnInfo(column).getYdbType();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

