/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbDatabaseMetaData;
import tech.ydb.jdbc.YdbPrepareMode;
import tech.ydb.jdbc.YdbPreparedStatement;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.YdbTracer;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbExecutor;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.impl.YdbDatabaseMetaDataImpl;
import tech.ydb.jdbc.impl.YdbPreparedStatementImpl;
import tech.ydb.jdbc.impl.YdbStatementImpl;
import tech.ydb.jdbc.query.YdbPreparedQuery;
import tech.ydb.jdbc.query.YdbQuery;

public class YdbConnectionImpl
implements YdbConnection {
    private static final Logger LOGGER = Logger.getLogger(YdbConnectionImpl.class.getName());
    private final YdbContext ctx;
    private final YdbValidator validator;
    private final YdbExecutor executor;

    public YdbConnectionImpl(YdbContext context) throws SQLException {
        this.ctx = context;
        this.validator = new YdbValidator();
        this.executor = this.ctx.createExecutor();
        this.ctx.register();
    }

    @Override
    public YdbStatement createStatement() throws SQLException {
        return this.createStatement(1004, 1007, 1);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007, 1);
    }

    @Override
    public String nativeSQL(String sql) {
        try {
            return this.ctx.parseYdbQuery(sql).getPreparedYql();
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.executor.ensureOpened();
        if (autoCommit == this.executor.isAutoCommit()) {
            return;
        }
        LOGGER.log(Level.FINE, "Set auto-commit: {0}", autoCommit);
        if (autoCommit) {
            this.commit();
        }
        this.executor.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.executor.isAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.executor.commit(this.ctx, this.validator);
    }

    @Override
    public void rollback() throws SQLException {
        this.executor.rollback(this.ctx, this.validator);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.commit();
        this.validator.clearWarnings();
        this.executor.close();
        this.ctx.deregister();
        YdbTracer.clear();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.executor.isClosed();
    }

    @Override
    public YdbDatabaseMetaData getMetaData() {
        return new YdbDatabaseMetaDataImpl(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.executor.isReadOnly() == readOnly) {
            return;
        }
        this.executor.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.executor.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.executor.transactionLevel() == level) {
            return;
        }
        LOGGER.log(Level.FINE, "Set transaction isolation level: {0}", level);
        this.executor.setTransactionLevel(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.executor.transactionLevel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.executor.ensureOpened();
        return this.validator.toSQLWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.executor.ensureOpened();
        this.validator.clearWarnings();
    }

    @Override
    public YdbStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.executor.ensureOpened();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("resultSetHoldability must be ResultSet.HOLD_CURSORS_OVER_COMMIT");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.executor.ensureOpened();
        return 1;
    }

    @Override
    public YdbStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.executor.ensureOpened();
        this.executor.trace("create statement");
        this.checkStatementParams(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new YdbStatementImpl(this, resultSetType);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String origSql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkStatementParams(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.prepareStatement(origSql, resultSetType, YdbPrepareMode.AUTO);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, YdbPrepareMode mode) throws SQLException {
        return this.prepareStatement(sql, 1004, mode);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
        }
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    private YdbPreparedStatement prepareStatement(String sql, int resultSetType, YdbPrepareMode mode) throws SQLException {
        this.executor.ensureOpened();
        this.validator.clearWarnings();
        this.executor.trace("--> prepare statement");
        YdbQuery query = this.ctx.findOrParseYdbQuery(sql);
        YdbPreparedQuery params = this.ctx.findOrPrepareParams(query, mode);
        this.executor.trace("<-- OK");
        return new YdbPreparedStatementImpl(this, query, params, resultSetType);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.executor.isValid(this.validator, timeout);
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public Properties getClientInfo() {
        return new Properties();
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return (int)this.ctx.getOperationProperties().getDeadlineTimeout().toMillis();
    }

    @Override
    public String getYdbTxId() throws SQLException {
        return this.executor.txID();
    }

    @Override
    public YdbContext getCtx() {
        return this.ctx;
    }

    @Override
    public YdbExecutor getExecutor() {
        return this.executor;
    }

    private void checkStatementParams(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004) {
            throw new SQLFeatureNotSupportedException("resultSetType must be ResultSet.TYPE_FORWARD_ONLY or ResultSet.TYPE_SCROLL_INSENSITIVE");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("resultSetConcurrency must be ResultSet.CONCUR_READ_ONLY");
        }
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("resultSetHoldability must be ResultSet.HOLD_CURSORS_OVER_COMMIT");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Prepared calls are not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Prepared calls are not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Prepared calls are not supported");
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs are not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Blobs are not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXMLs are not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Structs are not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Abort operation is not supported yet");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Set network timeout is not supported yet");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

