/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.ArrayList;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.YdbTracer;
import tech.ydb.jdbc.context.BaseYdbExecutor;
import tech.ydb.jdbc.context.StaticQueryResult;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.impl.YdbQueryResult;
import tech.ydb.jdbc.impl.YdbStaticResultSet;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.table.Session;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.ExplainDataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.settings.CommitTxSettings;
import tech.ydb.table.settings.ExecuteDataQuerySettings;
import tech.ydb.table.settings.ExplainDataQuerySettings;
import tech.ydb.table.settings.KeepAliveSessionSettings;
import tech.ydb.table.settings.RollbackTxSettings;
import tech.ydb.table.transaction.TxControl;

public class TableServiceExecutor
extends BaseYdbExecutor {
    private final boolean failOnTruncatedResult;
    private volatile TxState tx;

    public TableServiceExecutor(YdbContext ctx, int transactionLevel, boolean autoCommit) throws SQLException {
        super(ctx);
        this.tx = this.createTx(transactionLevel, autoCommit);
        this.failOnTruncatedResult = ctx.getOperationProperties().isFailOnTruncatedResult();
    }

    @Override
    public void close() throws SQLException {
        this.closeCurrentResult();
        this.tx = null;
    }

    private void updateState(TxState newTx) {
        if (this.tx == newTx || this.tx == null) {
            return;
        }
        this.tx = newTx;
    }

    @Override
    public void setTransactionLevel(int level) throws SQLException {
        this.ensureOpened();
        this.updateState(this.tx.withTransactionLevel(level));
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpened();
        this.updateState(this.tx.withReadOnly(readOnly));
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpened();
        this.updateState(this.tx.withAutoCommit(autoCommit));
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.closeCurrentResult();
        return this.tx == null;
    }

    @Override
    public String txID() throws SQLException {
        this.closeCurrentResult();
        return this.tx != null ? this.tx.txID() : null;
    }

    @Override
    public boolean isInsideTransaction() throws SQLException {
        this.ensureOpened();
        return this.tx.isInsideTransaction();
    }

    @Override
    public boolean isAutoCommit() throws SQLException {
        this.ensureOpened();
        return this.tx.isAutoCommit();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpened();
        return this.tx.isReadOnly();
    }

    @Override
    public int transactionLevel() throws SQLException {
        this.ensureOpened();
        return this.tx.transactionLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        if (!this.isInsideTransaction()) {
            return;
        }
        Session session = this.tx.getSession(validator);
        CommitTxSettings settings = ctx.withDefaultTimeout(new CommitTxSettings());
        YdbTracer tracer = this.traceRequest("commit", null);
        try {
            validator.clearWarnings();
            validator.execute("Commit TxId: " + this.tx.txID(), tracer, () -> session.commitTransaction(this.tx.txID(), settings));
        }
        finally {
            this.updateState(this.tx.withCommit(session));
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        if (!this.isInsideTransaction()) {
            return;
        }
        Session session = this.tx.getSession(validator);
        RollbackTxSettings settings = ctx.withDefaultTimeout(new RollbackTxSettings());
        YdbTracer tracer = this.traceRequest("rollback", null);
        try {
            validator.clearWarnings();
            validator.execute("Rollback TxId: " + this.tx.txID(), tracer, () -> session.rollbackTransaction(this.tx.txID(), settings));
        }
        finally {
            this.updateState(this.tx.withRollback(session));
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    private ExecuteDataQuerySettings dataQuerySettings(long timeout, boolean keepInCache) {
        ExecuteDataQuerySettings settings = new ExecuteDataQuerySettings();
        if (timeout > 0L) {
            settings = (ExecuteDataQuerySettings)((ExecuteDataQuerySettings)settings.setOperationTimeout(Duration.ofSeconds(timeout))).setTimeout(Duration.ofSeconds(timeout + 1L));
        }
        if (!keepInCache) {
            settings = settings.disableQueryCache();
        }
        return settings;
    }

    /*
     * Loose catch block
     */
    @Override
    public YdbQueryResult executeExplainQuery(YdbStatement statement, YdbQuery query) throws SQLException {
        this.ensureOpened();
        YdbContext ctx = statement.getConnection().getCtx();
        YdbValidator validator = statement.getValidator();
        String yql = this.prefixPragma + query.getPreparedYql();
        YdbTracer tracer = this.traceRequest("explain", yql);
        ExplainDataQuerySettings settings = ctx.withDefaultTimeout(new ExplainDataQuerySettings());
        try {
            try (Session session = this.createNewTableSession(validator);){
                String msg = (Object)((Object)QueryType.EXPLAIN_QUERY) + " >>\n" + yql;
                ExplainDataQueryResult res = (ExplainDataQueryResult)validator.call(msg, tracer, () -> session.explainDataQuery(yql, settings));
                YdbQueryResult ydbQueryResult = this.updateCurrentResult(new StaticQueryResult(statement, res.getQueryAst(), res.getQueryPlan()));
                return ydbQueryResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tracer != null && !this.tx.isInsideTransaction()) {
                tracer.close();
            }
        }
    }

    @Override
    public YdbQueryResult executeDataQuery(YdbStatement statement, YdbQuery query, String preparedYql, Params params, long timeout, boolean keepInCache) throws SQLException {
        this.ensureOpened();
        YdbValidator validator = statement.getValidator();
        Session session = this.tx.getSession(validator);
        String yql = this.prefixPragma + preparedYql;
        YdbTracer tracer = this.traceRequest("data query", yql);
        try {
            DataQueryResult result = (DataQueryResult)validator.call((Object)((Object)QueryType.DATA_QUERY) + " >>\n" + yql, tracer, () -> session.executeDataQuery(yql, this.tx.txControl(), params, this.dataQuerySettings(timeout, keepInCache)));
            this.updateState(this.tx.withDataQuery(session, result.getTxId()));
            ArrayList<YdbResultSet> readers = new ArrayList<YdbResultSet>();
            for (int idx = 0; idx < result.getResultSetCount(); ++idx) {
                ResultSetReader rs = result.getResultSet(idx);
                if (this.failOnTruncatedResult && rs.isTruncated()) {
                    String msg = String.format("Result #%s was truncated to %s rows", idx, rs.getRowCount());
                    throw new SQLException(msg);
                }
                readers.add(new YdbStaticResultSet(statement, rs));
            }
            YdbQueryResult ydbQueryResult = this.updateCurrentResult(new StaticQueryResult(query, readers));
            return ydbQueryResult;
        }
        catch (RuntimeException | SQLException ex) {
            this.updateState(this.tx.withRollback(session));
            throw ex;
        }
        finally {
            if (tracer != null) {
                if (this.tx.isInsideTransaction()) {
                    tracer.setId(this.tx.txID());
                } else {
                    tracer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(YdbValidator validator, int timeout) throws SQLException {
        this.ensureOpened();
        Session session = this.tx.getSession(validator);
        try {
            KeepAliveSessionSettings settings = (KeepAliveSessionSettings)new KeepAliveSessionSettings().setTimeout(Duration.ofSeconds(timeout));
            Session.State keepAlive = (Session.State)validator.call("Keep alive: " + this.tx.txID(), null, () -> session.keepAlive(settings));
            boolean bl = keepAlive == Session.State.READY;
            return bl;
        }
        finally {
            this.updateState(this.tx.withKeepAlive(session));
        }
    }

    private TxState emptyTx(int level, boolean isReadOnly, boolean isAutoCommit) throws SQLException {
        TxControl<?> txCtrl = TableServiceExecutor.txControl(level, isReadOnly, isAutoCommit);
        return new TxState(txCtrl, level, isReadOnly, isAutoCommit);
    }

    private TxState createTx(int level, boolean isAutoCommit) throws SQLException {
        return this.emptyTx(level, level != 8, isAutoCommit);
    }

    private static TxControl<?> txControl(int level, boolean isReadOnly, boolean isAutoCommit) throws SQLException {
        if (!isReadOnly) {
            if (level != 8) {
                throw new SQLException("Unsupported transaction level: " + level);
            }
            return TxControl.serializableRw().setCommitTx(isAutoCommit);
        }
        switch (level) {
            case 8: {
                return TxControl.snapshotRo().setCommitTx(isAutoCommit);
            }
            case 16: {
                return TxControl.onlineRo().setAllowInconsistentReads(false).setCommitTx(isAutoCommit);
            }
            case 17: {
                return TxControl.onlineRo().setAllowInconsistentReads(true).setCommitTx(isAutoCommit);
            }
            case 32: {
                return TxControl.staleRo().setCommitTx(isAutoCommit);
            }
        }
        throw new SQLException("Unsupported transaction level: " + level);
    }

    private class TransactionInProgress
    extends TxState {
        private final String txID;
        private final Session session;
        private final TxState previos;

        TransactionInProgress(String id, Session session, TxState previosState) {
            super((TxControl<?>)TxControl.id((String)id).setCommitTx(previosState.isAutoCommit), previosState);
            this.txID = id;
            this.session = session;
            this.previos = previosState;
        }

        @Override
        public String toString() {
            return "InTx" + this.transactionLevel() + "[" + this.txID + "]";
        }

        @Override
        public String txID() {
            return this.txID;
        }

        @Override
        public boolean isInsideTransaction() {
            return true;
        }

        @Override
        public Session getSession(YdbValidator validator) throws SQLException {
            return this.session;
        }

        @Override
        public TxState withCommit(Session session) {
            session.close();
            return this.previos;
        }

        @Override
        public TxState withRollback(Session session) {
            session.close();
            return this.previos;
        }

        @Override
        public TxState withKeepAlive(Session session) {
            return this;
        }

        @Override
        public TxState withDataQuery(Session session, String txID) {
            if (txID == null || txID.isEmpty()) {
                if (this.session != session) {
                    session.close();
                }
                this.session.close();
                return this.previos;
            }
            if (txID.equals(this.txID())) {
                if (this.session == session) {
                    return this;
                }
                this.session.close();
                return new TransactionInProgress(txID, session, this.previos);
            }
            session.close();
            return this;
        }
    }

    private class TxState {
        private final int transactionLevel;
        private final boolean isReadOnly;
        private final boolean isAutoCommit;
        private final TxControl<?> txControl;

        protected TxState(TxControl<?> txControl, int level, boolean isReadOnly, boolean isAutoCommit) {
            this.transactionLevel = level;
            this.isReadOnly = isReadOnly;
            this.isAutoCommit = isAutoCommit;
            this.txControl = txControl;
        }

        protected TxState(TxControl<?> txControl, TxState other) {
            this.transactionLevel = other.transactionLevel;
            this.isReadOnly = other.isReadOnly;
            this.isAutoCommit = other.isAutoCommit;
            this.txControl = txControl;
        }

        public String toString() {
            return "NoTx";
        }

        public String txID() {
            return null;
        }

        public boolean isInsideTransaction() {
            return false;
        }

        public TxControl<?> txControl() {
            return this.txControl;
        }

        public boolean isAutoCommit() {
            return this.isAutoCommit;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public int transactionLevel() {
            return this.transactionLevel;
        }

        public TxState withAutoCommit(boolean newAutoCommit) throws SQLException {
            if (newAutoCommit == this.isAutoCommit) {
                return this;
            }
            if (this.isInsideTransaction()) {
                throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
            }
            return TableServiceExecutor.this.emptyTx(this.transactionLevel, this.isReadOnly, newAutoCommit);
        }

        public TxState withReadOnly(boolean newReadOnly) throws SQLException {
            if (newReadOnly == this.isReadOnly()) {
                return this;
            }
            if (this.isInsideTransaction()) {
                throw new SQLFeatureNotSupportedException("Cannot change read-only attribute inside a transaction");
            }
            return TableServiceExecutor.this.emptyTx(this.transactionLevel, newReadOnly, this.isAutoCommit);
        }

        public TxState withTransactionLevel(int newTransactionLevel) throws SQLException {
            if (newTransactionLevel == this.transactionLevel) {
                return this;
            }
            if (this.isInsideTransaction()) {
                throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
            }
            boolean newReadOnly = this.isReadOnly || newTransactionLevel != 8;
            return TableServiceExecutor.this.emptyTx(newTransactionLevel, newReadOnly, this.isAutoCommit);
        }

        public TxState withCommit(Session session) {
            session.close();
            return this;
        }

        public TxState withRollback(Session session) {
            session.close();
            return this;
        }

        public TxState withKeepAlive(Session session) {
            session.close();
            return this;
        }

        public TxState withDataQuery(Session session, String txID) {
            if (txID != null && !txID.isEmpty()) {
                return new TransactionInProgress(txID, session, this);
            }
            session.close();
            return this;
        }

        public Session getSession(YdbValidator validator) throws SQLException {
            return TableServiceExecutor.this.createNewTableSession(validator);
        }
    }
}

