/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import tech.ydb.table.values.DecimalType;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.ListType;
import tech.ydb.table.values.ListValue;
import tech.ydb.table.values.OptionalType;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.PrimitiveValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class MappingSetters {
    private static final int DEFAULT_BUF_SIZE = 2048;

    private MappingSetters() {
    }

    static Setters buildSetters(Type type) {
        return MappingSetters.buildToValueImpl(type);
    }

    private static Setters buildToValueImpl(Type type) {
        Type.Kind kind = type.getKind();
        if (kind == Type.Kind.PRIMITIVE) {
            PrimitiveType id = (PrimitiveType)type;
            switch (id) {
                case Bytes: {
                    return x -> PrimitiveValue.newBytesOwn((byte[])MappingSetters.castAsBytes(id, x));
                }
                case Text: {
                    return x -> PrimitiveValue.newText((String)MappingSetters.castAsString(id, x));
                }
                case Json: {
                    return x -> PrimitiveValue.newJson((String)MappingSetters.castAsJson(id, x));
                }
                case JsonDocument: {
                    return x -> PrimitiveValue.newJsonDocument((String)MappingSetters.castAsJson(id, x));
                }
                case Yson: {
                    return x -> PrimitiveValue.newYsonOwn((byte[])MappingSetters.castAsYson(id, x));
                }
                case Uuid: {
                    return x -> MappingSetters.castAsUuid(id, x);
                }
                case Bool: {
                    return x -> PrimitiveValue.newBool((boolean)MappingSetters.castAsBoolean(id, x));
                }
                case Int8: {
                    return x -> PrimitiveValue.newInt8((byte)MappingSetters.castAsByte(id, x));
                }
                case Uint8: {
                    return x -> PrimitiveValue.newUint8((int)MappingSetters.castAsByte(id, x));
                }
                case Int16: {
                    return x -> PrimitiveValue.newInt16((short)MappingSetters.castAsShort(id, x));
                }
                case Uint16: {
                    return x -> PrimitiveValue.newUint16((int)MappingSetters.castAsShort(id, x));
                }
                case Int32: {
                    return x -> PrimitiveValue.newInt32((int)MappingSetters.castAsInt(id, x));
                }
                case Uint32: {
                    return x -> PrimitiveValue.newUint32((long)MappingSetters.castAsInt(id, x));
                }
                case Int64: {
                    return x -> PrimitiveValue.newInt64((long)MappingSetters.castAsLong(id, x));
                }
                case Uint64: {
                    return x -> PrimitiveValue.newUint64((long)MappingSetters.castAsLong(id, x));
                }
                case Float: {
                    return x -> PrimitiveValue.newFloat((float)MappingSetters.castAsFloat(id, x));
                }
                case Double: {
                    return x -> PrimitiveValue.newDouble((double)MappingSetters.castAsDouble(id, x));
                }
                case Date: {
                    return x -> MappingSetters.castToDate(id, x);
                }
                case Datetime: {
                    return x -> MappingSetters.castToDateTime(id, x);
                }
                case Timestamp: {
                    return x -> MappingSetters.castToTimestamp(id, x);
                }
                case Interval: {
                    return x -> MappingSetters.castToInterval(id, x);
                }
                case TzDate: {
                    return x -> PrimitiveValue.newTzDate((ZonedDateTime)MappingSetters.castAsZonedDateTime(id, x));
                }
                case TzDatetime: {
                    return x -> PrimitiveValue.newTzDatetime((ZonedDateTime)MappingSetters.castAsZonedDateTime(id, x));
                }
                case TzTimestamp: {
                    return x -> PrimitiveValue.newTzTimestamp((ZonedDateTime)MappingSetters.castAsZonedDateTime(id, x));
                }
            }
            return x -> {
                throw MappingSetters.castNotSupported(id, x);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return x -> MappingSetters.castToDecimalValue((DecimalType)type, x);
        }
        if (kind == Type.Kind.LIST) {
            ListType listType = (ListType)type;
            Setters itemSetter = MappingSetters.buildToValueImpl(listType.getItemType());
            return x -> MappingSetters.castAsList(listType, itemSetter, x);
        }
        if (kind == Type.Kind.OPTIONAL) {
            return MappingSetters.buildToValueImpl(((OptionalType)type).getItemType());
        }
        return x -> {
            throw MappingSetters.castNotSupported(kind, x);
        };
    }

    private static String toString(Object x) {
        return x == null ? "null" : x.getClass() + ": " + x;
    }

    private static SQLException castNotSupported(PrimitiveType type, Object x, Exception cause) {
        return new SQLException(String.format("Cannot cast [%s] to [%s]", MappingSetters.toString(x), type), cause);
    }

    private static SQLException castNotSupported(PrimitiveType type, Object x) {
        return new SQLException(String.format("Cannot cast [%s] to [%s]", MappingSetters.toString(x), type));
    }

    private static SQLException castNotSupported(Type.Kind kind, Object x) {
        return new SQLException(String.format("Cannot cast [%s] to [%s]", MappingSetters.toString(x), kind));
    }

    private static ListValue castAsList(ListType type, Setters itemSetter, Object x) throws SQLException {
        if (x instanceof Collection) {
            Collection values = (Collection)x;
            int len = values.size();
            Value[] result = new Value[len];
            int index = 0;
            for (Object value : values) {
                if (value == null) continue;
                if (value instanceof Value) {
                    result[index++] = (Value)value;
                    continue;
                }
                result[index++] = itemSetter.toValue(value);
            }
            if (index < result.length) {
                result = Arrays.copyOf(result, index);
            }
            return type.newValueOwn(result);
        }
        throw MappingSetters.castNotSupported(type.getKind(), x);
    }

    private static byte[] castAsBytes(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        if (x instanceof InputStream) {
            return ByteStream.fromInputStream((InputStream)x, -1L).asByteArray();
        }
        if (x instanceof Reader) {
            return CharStream.fromReader((Reader)x, -1L).asString().getBytes();
        }
        if (x instanceof ByteStream) {
            return ((ByteStream)x).asByteArray();
        }
        if (x instanceof CharStream) {
            return ((CharStream)x).asString().getBytes();
        }
        return MappingSetters.castAsString(type, x).getBytes();
    }

    private static byte[] castAsYson(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof byte[]) {
            return (byte[])x;
        }
        if (x instanceof String) {
            return ((String)x).getBytes();
        }
        if (x instanceof InputStream) {
            return ByteStream.fromInputStream((InputStream)x, -1L).asByteArray();
        }
        if (x instanceof Reader) {
            return CharStream.fromReader((Reader)x, -1L).asString().getBytes();
        }
        if (x instanceof ByteStream) {
            return ((ByteStream)x).asByteArray();
        }
        if (x instanceof CharStream) {
            return ((CharStream)x).asString().getBytes();
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static String castAsString(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof String) {
            return (String)x;
        }
        if (x instanceof byte[]) {
            return new String((byte[])x);
        }
        if (x instanceof InputStream) {
            return new String(ByteStream.fromInputStream((InputStream)x, -1L).asByteArray());
        }
        if (x instanceof Reader) {
            return CharStream.fromReader((Reader)x, -1L).asString();
        }
        if (x instanceof ByteStream) {
            return new String(((ByteStream)x).asByteArray());
        }
        if (x instanceof CharStream) {
            return ((CharStream)x).asString();
        }
        return String.valueOf(x);
    }

    private static String castAsJson(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof String) {
            return (String)x;
        }
        if (x instanceof byte[]) {
            return new String((byte[])x);
        }
        if (x instanceof InputStream) {
            return new String(ByteStream.fromInputStream((InputStream)x, -1L).asByteArray());
        }
        if (x instanceof Reader) {
            return CharStream.fromReader((Reader)x, -1L).asString();
        }
        if (x instanceof ByteStream) {
            return new String(((ByteStream)x).asByteArray());
        }
        if (x instanceof CharStream) {
            return ((CharStream)x).asString();
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static PrimitiveValue castAsUuid(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof String) {
            return PrimitiveValue.newUuid((String)((String)x));
        }
        if (x instanceof byte[]) {
            return PrimitiveValue.newUuid((String)new String((byte[])x));
        }
        if (x instanceof UUID) {
            return PrimitiveValue.newUuid((UUID)((UUID)x));
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static byte castAsByte(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Byte) {
            return (Byte)x;
        }
        if (x instanceof Short) {
            return ((Short)x).byteValue();
        }
        if (x instanceof Integer) {
            return ((Integer)x).byteValue();
        }
        if (x instanceof Long) {
            return ((Long)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (byte)((Boolean)x != false ? 1 : 0);
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static short castAsShort(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Short) {
            return (Short)x;
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof Integer) {
            return ((Integer)x).shortValue();
        }
        if (x instanceof Long) {
            return ((Long)x).shortValue();
        }
        if (x instanceof Boolean) {
            return (short)((Boolean)x != false ? 1 : 0);
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static int castAsInt(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof Long) {
            return ((Long)x).intValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1 : 0;
        }
        if (x instanceof Time) {
            return ((Time)x).toLocalTime().toSecondOfDay();
        }
        if (x instanceof Date) {
            return (int)((Date)x).toLocalDate().toEpochDay();
        }
        if (x instanceof Timestamp) {
            return (int)((Timestamp)x).getTime();
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static long castAsLong(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Long) {
            return (Long)x;
        }
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1L : 0L;
        }
        if (x instanceof BigInteger) {
            return ((BigInteger)x).longValue();
        }
        if (x instanceof Time) {
            return ((Time)x).toLocalTime().toSecondOfDay();
        }
        if (x instanceof Date) {
            return ((Date)x).toLocalDate().toEpochDay();
        }
        if (x instanceof Timestamp) {
            return ((Timestamp)x).getTime();
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static float castAsFloat(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Float) {
            return ((Float)x).floatValue();
        }
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0f : 0.0f;
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static double castAsDouble(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Double) {
            return (Double)x;
        }
        if (x instanceof Float) {
            return ((Float)x).floatValue();
        }
        if (x instanceof Long) {
            return ((Long)x).longValue();
        }
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? 1.0 : 0.0;
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static boolean castAsBoolean(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            long lValue = ((Number)x).longValue();
            return lValue > 0L;
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static ZonedDateTime castAsZonedDateTime(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof ZonedDateTime) {
            return (ZonedDateTime)x;
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static PrimitiveValue castToInterval(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Duration) {
            return PrimitiveValue.newInterval((Duration)((Duration)x));
        }
        if (x instanceof Long) {
            return PrimitiveValue.newInterval((long)((Long)x));
        }
        if (x instanceof String) {
            Duration parsed;
            try {
                parsed = Duration.parse((String)x);
            }
            catch (DateTimeParseException e) {
                throw MappingSetters.castNotSupported(type, x, e);
            }
            return PrimitiveValue.newInterval((Duration)parsed);
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static PrimitiveValue castToDate(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Instant) {
            return PrimitiveValue.newDate((LocalDate)((Instant)x).atZone(ZoneId.systemDefault()).toLocalDate());
        }
        if (x instanceof LocalDateTime) {
            return PrimitiveValue.newDate((LocalDate)((LocalDateTime)x).toLocalDate());
        }
        if (x instanceof LocalDate) {
            return PrimitiveValue.newDate((LocalDate)((LocalDate)x));
        }
        if (x instanceof Integer) {
            return PrimitiveValue.newDate((LocalDate)LocalDate.ofEpochDay(((Integer)x).intValue()));
        }
        if (x instanceof Long) {
            return PrimitiveValue.newDate((LocalDate)LocalDate.ofEpochDay((Long)x));
        }
        if (x instanceof Timestamp) {
            Instant instant = Instant.ofEpochMilli(((Timestamp)x).getTime());
            LocalDate ld = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            return PrimitiveValue.newDate((LocalDate)ld);
        }
        if (x instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)x).getTime());
            LocalDate ld = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            return PrimitiveValue.newDate((LocalDate)ld);
        }
        if (x instanceof String) {
            try {
                return PrimitiveValue.newDate((LocalDate)LocalDate.parse((String)x));
            }
            catch (DateTimeParseException e) {
                throw MappingSetters.castNotSupported(type, x, e);
            }
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static PrimitiveValue castToDateTime(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Instant) {
            return PrimitiveValue.newDatetime((LocalDateTime)((Instant)x).atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        if (x instanceof LocalDateTime) {
            return PrimitiveValue.newDatetime((LocalDateTime)((LocalDateTime)x));
        }
        if (x instanceof LocalDate) {
            return PrimitiveValue.newDatetime((LocalDateTime)((LocalDate)x).atStartOfDay());
        }
        if (x instanceof Long) {
            return PrimitiveValue.newDatetime((LocalDateTime)LocalDateTime.ofEpochSecond((Long)x, 0, ZoneOffset.UTC));
        }
        if (x instanceof Timestamp) {
            Instant instant = Instant.ofEpochMilli(((Timestamp)x).getTime());
            LocalDateTime ldt = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
            return PrimitiveValue.newDatetime((LocalDateTime)ldt);
        }
        if (x instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)x).getTime());
            LocalDate ld = instant.atZone(ZoneId.systemDefault()).toLocalDate();
            return PrimitiveValue.newDatetime((LocalDateTime)ld.atStartOfDay());
        }
        if (x instanceof String) {
            try {
                return PrimitiveValue.newDatetime((LocalDateTime)LocalDateTime.parse((String)x));
            }
            catch (DateTimeParseException e) {
                throw MappingSetters.castNotSupported(type, x, e);
            }
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static PrimitiveValue castToTimestamp(PrimitiveType type, Object x) throws SQLException {
        if (x instanceof Instant) {
            return PrimitiveValue.newTimestamp((Instant)((Instant)x));
        }
        if (x instanceof Long) {
            return PrimitiveValue.newTimestamp((Instant)Instant.ofEpochMilli((Long)x));
        }
        if (x instanceof LocalDate) {
            return PrimitiveValue.newTimestamp((Instant)((LocalDate)x).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        if (x instanceof LocalDateTime) {
            long epochSeconds = ((LocalDateTime)x).toEpochSecond(ZoneOffset.UTC);
            return PrimitiveValue.newTimestamp((Instant)Instant.ofEpochSecond(epochSeconds));
        }
        if (x instanceof Timestamp) {
            return PrimitiveValue.newTimestamp((Instant)((Timestamp)x).toInstant());
        }
        if (x instanceof Date) {
            Instant instant = ((Date)x).toLocalDate().atStartOfDay().toInstant(ZoneOffset.UTC);
            return PrimitiveValue.newTimestamp((Instant)instant);
        }
        if (x instanceof String) {
            try {
                return PrimitiveValue.newTimestamp((Instant)Instant.parse((String)x));
            }
            catch (DateTimeParseException e) {
                throw MappingSetters.castNotSupported(type, x, e);
            }
        }
        throw MappingSetters.castNotSupported(type, x);
    }

    private static DecimalValue validateValue(DecimalType type, DecimalValue value, Object x) throws SQLException {
        if (value.isInf()) {
            throw new SQLException(String.format("Cannot cast to decimal type %s: [%s] is %s", type, MappingSetters.toString(x), "Infinite"));
        }
        if (value.isNegativeInf()) {
            throw new SQLException(String.format("Cannot cast to decimal type %s: [%s] is %s", type, MappingSetters.toString(x), "-Infinite"));
        }
        if (value.isNan()) {
            throw new SQLException(String.format("Cannot cast to decimal type %s: [%s] is %s", type, MappingSetters.toString(x), "NaN"));
        }
        return value;
    }

    private static DecimalValue castToDecimalValue(DecimalType type, Object x) throws SQLException {
        if (x instanceof DecimalValue) {
            return MappingSetters.validateValue(type, (DecimalValue)x, x);
        }
        if (x instanceof BigDecimal) {
            return MappingSetters.validateValue(type, type.newValue((BigDecimal)x), x);
        }
        if (x instanceof BigInteger) {
            return MappingSetters.validateValue(type, type.newValue((BigInteger)x), x);
        }
        if (x instanceof Long) {
            return MappingSetters.validateValue(type, type.newValue(((Long)x).longValue()), x);
        }
        if (x instanceof Integer) {
            return MappingSetters.validateValue(type, type.newValue((long)((Integer)x).intValue()), x);
        }
        if (x instanceof Short) {
            return MappingSetters.validateValue(type, type.newValue((long)((Short)x).shortValue()), x);
        }
        if (x instanceof Byte) {
            return MappingSetters.validateValue(type, type.newValue((long)((Byte)x).byteValue()), x);
        }
        if (x instanceof String) {
            return MappingSetters.validateValue(type, type.newValue((String)x), x);
        }
        throw MappingSetters.castNotSupported(type.getKind(), x);
    }

    public static interface ByteStream {
        public byte[] asByteArray() throws SQLException;

        public static ByteStream fromInputStream(InputStream stream, long length) {
            return () -> {
                try {
                    if (length >= 0L) {
                        return ByteStreams.toByteArray((InputStream)ByteStreams.limit((InputStream)stream, (long)length));
                    }
                    return ByteStreams.toByteArray((InputStream)stream);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load data from input stream: " + e.getMessage(), e);
                }
            };
        }
    }

    public static interface CharStream {
        public String asString() throws SQLException;

        public static CharStream fromReader(Reader reader, long length) {
            return () -> {
                try {
                    int nRead;
                    char[] buf = new char[2048];
                    StringBuilder sb = new StringBuilder();
                    long total = 0L;
                    while ((nRead = reader.read(buf)) != -1) {
                        if (length < 0L || (total += (long)nRead) < length) {
                            sb.append(buf, 0, nRead);
                            continue;
                        }
                        sb.append(buf, 0, nRead - (int)(total - length));
                        break;
                    }
                    return sb.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load data from reader: " + e.getMessage(), e);
                }
            };
        }
    }

    public static interface Setters {
        public Value<?> toValue(Object var1) throws SQLException;
    }
}

