/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbDriverInfo;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.impl.YdbConnectionImpl;
import tech.ydb.jdbc.settings.YdbConfig;

public class YdbDriver
implements Driver {
    private static final Logger PARENT_LOGGER = Logger.getLogger("tech.ydb.jdbc");
    private static final Logger LOGGER = Logger.getLogger(YdbDriver.class.getName());
    @Nullable
    private static YdbDriver registeredDriver;
    private final ConcurrentHashMap<YdbConfig, YdbContext> cache = new ConcurrentHashMap();

    @Override
    public YdbConnection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        final YdbConfig config = YdbConfig.from(url, info);
        LOGGER.log(Level.FINE, "About to connect to [{0}] using properties {1}", new Object[]{config.getSafeUrl(), config.getSafeProps()});
        if (!config.isCacheConnectionsInDriver()) {
            final YdbContext context = YdbContext.createContext(config);
            return new YdbConnectionImpl(context){

                @Override
                public void close() throws SQLException {
                    super.close();
                    context.close();
                }
            };
        }
        final YdbContext cached = this.getCachedContext(config);
        return new YdbConnectionImpl(cached){

            @Override
            public void close() throws SQLException {
                super.close();
                if (!cached.hasConnections() && YdbDriver.this.cache.remove(config, cached)) {
                    cached.close();
                }
            }
        };
    }

    public YdbContext getCachedContext(YdbConfig config) throws SQLException {
        YdbContext context = this.cache.get(config);
        if (context != null) {
            LOGGER.log(Level.FINE, "Reusing YDB connection to {0}", config.getSafeUrl());
            return context;
        }
        context = YdbContext.createContext(config);
        YdbContext old = this.cache.putIfAbsent(config, context);
        if (old != null) {
            context.close();
            return old;
        }
        return context;
    }

    @Override
    public boolean acceptsURL(String url) {
        return YdbConfig.isYdb(url);
    }

    public String toString() {
        return YdbDriverInfo.DRIVER_FULL_NAME;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        YdbConfig config = YdbConfig.from(url, info);
        return config.toPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return YdbDriverInfo.DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return YdbDriverInfo.DRIVER_MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return PARENT_LOGGER;
    }

    public int getConnectionCount() {
        return this.cache.size();
    }

    public void close() {
        if (!this.cache.isEmpty()) {
            LOGGER.log(Level.FINE, "Closing {0} cached connection(s)...", this.cache.size());
            this.cache.values().forEach(YdbContext::close);
            this.cache.clear();
        }
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public static void register() throws SQLException {
        if (YdbDriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        YdbDriver driver = new YdbDriver();
        DriverManager.registerDriver(driver);
        registeredDriver = driver;
        LOGGER.log(Level.INFO, "YDB JDBC Driver registered: {0}", registeredDriver);
    }

    public static void deregister() throws SQLException {
        if (!YdbDriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using YdbDriver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver.close();
        LOGGER.log(Level.INFO, "YDB JDBC Driver deregistered: {0}", registeredDriver);
        registeredDriver = null;
    }

    static {
        try {
            YdbDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

