/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLException;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.table.values.OptionalValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class ParamDescription {
    private final int index;
    private final String name;
    private final String displayName;
    private final TypeDescription type;

    public ParamDescription(int index, String name, String displayName, TypeDescription type) {
        this.index = index;
        this.name = name;
        this.displayName = displayName;
        this.type = type;
    }

    public ParamDescription(int index, String name, TypeDescription type) {
        this(index, name, name, type);
    }

    public int index() {
        return this.index;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public TypeDescription type() {
        return this.type;
    }

    protected Value<?> getValue(Object value) throws SQLException {
        if (value == null) {
            if (this.type.nullValue() != null) {
                return this.type.nullValue();
            }
            return this.type.ydbType().makeOptional().emptyValue();
        }
        if (value instanceof Value) {
            Value ydbValue = (Value)value;
            if (this.type.isOptional()) {
                if (ydbValue instanceof OptionalValue) {
                    this.checkType(ydbValue.asOptional().getType().getItemType());
                    return ydbValue;
                }
                this.checkType(ydbValue.getType());
                return ydbValue.makeOptional();
            }
            if (ydbValue instanceof OptionalValue) {
                OptionalValue optional = ydbValue.asOptional();
                if (!optional.isPresent()) {
                    throw new SQLException("Missing required value for parameter: " + this.displayName);
                }
                this.checkType(optional.getType().getItemType());
                return optional.get();
            }
            this.checkType(ydbValue.getType());
            return ydbValue;
        }
        Value<?> targetValue = this.type.setters().toValue(value);
        if (this.type.isOptional()) {
            return targetValue.makeOptional();
        }
        return targetValue;
    }

    private void checkType(Type objectType) throws SQLException {
        if (!this.type.ydbType().equals((Object)objectType)) {
            String msg = String.format("Cannot cast parameter [%s] from [%s] to [%s]", this.displayName, objectType, this.type.ydbType());
            throw new SQLException(msg);
        }
    }
}

