/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbExpression;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.settings.YdbQueryProperties;

public class YdbQueryBuilder {
    private final String origin;
    private final StringBuilder query;
    private final List<String> args = new ArrayList<String>();
    private final QueryType forcedType;
    private final List<YdbExpression> expressions = new ArrayList<YdbExpression>();
    private int argsCounter = 0;
    private QueryType currentType = null;

    public YdbQueryBuilder(String origin, QueryType forcedType) {
        this.origin = origin;
        this.query = new StringBuilder(origin.length() + 10);
        this.forcedType = forcedType;
    }

    public String createNextArgName() {
        String next;
        do {
            ++this.argsCounter;
        } while (this.origin.contains(next = "$jp" + this.argsCounter));
        this.args.add(next);
        return next;
    }

    public void addExpression(QueryType type, YdbExpression expression) throws SQLException {
        this.expressions.add(expression);
        if (this.forcedType != null) {
            return;
        }
        if (this.currentType != null && this.currentType != type) {
            throw new SQLFeatureNotSupportedException("Query cannot contain expressions with different types: " + (Object)((Object)this.currentType) + ", " + (Object)((Object)type));
        }
        this.currentType = type;
    }

    public QueryType getQueryType() {
        if (this.forcedType != null) {
            return this.forcedType;
        }
        if (this.currentType != null) {
            return this.currentType;
        }
        return QueryType.DATA_QUERY;
    }

    public List<YdbExpression> getExpressions() {
        return this.expressions;
    }

    public String getOriginSQL() {
        return this.origin;
    }

    public String buildYQL() {
        return this.query.toString();
    }

    public List<String> getIndexedArgs() {
        return this.args;
    }

    public void append(char[] chars, int start, int end) {
        this.query.append(chars, start, end);
    }

    public void append(char ch) {
        this.query.append(ch);
    }

    public void append(String string) {
        this.query.append(string);
    }

    public YdbQuery build(YdbQueryProperties opts) {
        return new YdbQuery(opts, this);
    }
}

