/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbExpression;
import tech.ydb.jdbc.query.YdbQueryBuilder;
import tech.ydb.jdbc.settings.YdbQueryProperties;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.Value;

public class YdbQuery {
    private final YdbQueryProperties opts;
    private final String originSQL;
    private final String yqlQuery;
    private final QueryType type;
    private final List<String> indexesArgsNames;
    private final List<YdbExpression> expressions;

    YdbQuery(YdbQueryProperties opts, YdbQueryBuilder builder) {
        this.opts = opts;
        this.originSQL = builder.getOriginSQL();
        this.yqlQuery = builder.buildYQL();
        this.indexesArgsNames = builder.getIndexedArgs();
        this.type = builder.getQueryType();
        this.expressions = builder.getExpressions();
    }

    public String originSQL() {
        return this.originSQL;
    }

    public List<YdbExpression> getExpressions() {
        return this.expressions;
    }

    public boolean hasIndexesParameters() {
        return this.indexesArgsNames != null && !this.indexesArgsNames.isEmpty();
    }

    public List<String> getIndexesParameters() {
        return this.indexesArgsNames;
    }

    public String getYqlQuery(Params params) throws SQLException {
        StringBuilder yql = new StringBuilder();
        if (this.indexesArgsNames != null) {
            if (params != null) {
                Map values = params.values();
                for (int idx = 0; idx < this.indexesArgsNames.size(); ++idx) {
                    String prm = this.indexesArgsNames.get(idx);
                    if (!values.containsKey(prm)) {
                        throw new SQLDataException("Missing value for parameter: " + prm);
                    }
                    if (!this.opts.isDeclareJdbcParameters()) continue;
                    String prmType = ((Value)values.get(prm)).getType().toString();
                    yql.append("DECLARE ").append(prm).append(" AS ").append(prmType).append(";\n");
                }
            } else if (!this.indexesArgsNames.isEmpty() && this.opts.isDeclareJdbcParameters()) {
                yql.append("-- DECLARE ").append(this.indexesArgsNames.size()).append(" PARAMETERS").append("\n");
            }
        }
        yql.append(this.yqlQuery);
        return yql.toString();
    }

    public QueryType type() {
        return this.type;
    }
}

