/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import io.grpc.netty.shaded.io.netty.util.collection.IntObjectHashMap;
import io.grpc.netty.shaded.io.netty.util.collection.IntObjectMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import tech.ydb.jdbc.YdbTypes;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;

public class YdbTypesImpl
implements YdbTypes {
    private static final YdbTypesImpl INSTANCE = new YdbTypesImpl();
    private final IntObjectMap<Type> typeBySqlType;
    private final Map<PrimitiveType, Integer> sqlTypeByPrimitiveNumId;
    private final Map<Class<?>, Type> typeByClass;
    private final Map<String, Type> typeByTypeName;

    private YdbTypesImpl() {
        PrimitiveType[] values = PrimitiveType.values();
        this.typeByTypeName = new HashMap<String, Type>(values.length + 1);
        for (PrimitiveType type : values) {
            this.typeByTypeName.put(type.toString(), (Type)type);
        }
        this.typeByTypeName.put(DEFAULT_DECIMAL_TYPE.toString(), (Type)DEFAULT_DECIMAL_TYPE);
        this.typeByTypeName.put("String", (Type)PrimitiveType.Bytes);
        this.typeByTypeName.put("Utf8", (Type)PrimitiveType.Text);
        this.typeBySqlType = new IntObjectHashMap(16);
        this.typeBySqlType.put(12, (Object)PrimitiveType.Text);
        this.typeBySqlType.put(-5, (Object)PrimitiveType.Int64);
        this.typeBySqlType.put(-6, (Object)PrimitiveType.Int8);
        this.typeBySqlType.put(5, (Object)PrimitiveType.Int16);
        this.typeBySqlType.put(4, (Object)PrimitiveType.Int32);
        this.typeBySqlType.put(7, (Object)PrimitiveType.Float);
        this.typeBySqlType.put(6, (Object)PrimitiveType.Float);
        this.typeBySqlType.put(8, (Object)PrimitiveType.Double);
        this.typeBySqlType.put(-7, (Object)PrimitiveType.Bool);
        this.typeBySqlType.put(16, (Object)PrimitiveType.Bool);
        this.typeBySqlType.put(-2, (Object)PrimitiveType.Bytes);
        this.typeBySqlType.put(-3, (Object)PrimitiveType.Bytes);
        this.typeBySqlType.put(91, (Object)PrimitiveType.Date);
        this.typeBySqlType.put(92, (Object)PrimitiveType.Datetime);
        this.typeBySqlType.put(93, (Object)PrimitiveType.Timestamp);
        this.typeBySqlType.put(2014, (Object)PrimitiveType.TzTimestamp);
        this.typeBySqlType.put(3, (Object)DEFAULT_DECIMAL_TYPE);
        this.typeBySqlType.put(2, (Object)DEFAULT_DECIMAL_TYPE);
        this.typeByClass = new HashMap(32);
        this.typeByClass.put(String.class, (Type)PrimitiveType.Text);
        this.typeByClass.put(Long.TYPE, (Type)PrimitiveType.Int64);
        this.typeByClass.put(Long.class, (Type)PrimitiveType.Int64);
        this.typeByClass.put(BigInteger.class, (Type)PrimitiveType.Int64);
        this.typeByClass.put(Byte.TYPE, (Type)PrimitiveType.Int8);
        this.typeByClass.put(Byte.class, (Type)PrimitiveType.Int8);
        this.typeByClass.put(Short.TYPE, (Type)PrimitiveType.Int16);
        this.typeByClass.put(Short.class, (Type)PrimitiveType.Int16);
        this.typeByClass.put(Integer.TYPE, (Type)PrimitiveType.Int32);
        this.typeByClass.put(Integer.class, (Type)PrimitiveType.Int32);
        this.typeByClass.put(Float.TYPE, (Type)PrimitiveType.Float);
        this.typeByClass.put(Float.class, (Type)PrimitiveType.Float);
        this.typeByClass.put(Double.TYPE, (Type)PrimitiveType.Double);
        this.typeByClass.put(Double.class, (Type)PrimitiveType.Double);
        this.typeByClass.put(Boolean.TYPE, (Type)PrimitiveType.Bool);
        this.typeByClass.put(Boolean.class, (Type)PrimitiveType.Bool);
        this.typeByClass.put(byte[].class, (Type)PrimitiveType.Bytes);
        this.typeByClass.put(java.util.Date.class, (Type)PrimitiveType.Timestamp);
        this.typeByClass.put(Date.class, (Type)PrimitiveType.Date);
        this.typeByClass.put(LocalDate.class, (Type)PrimitiveType.Date);
        this.typeByClass.put(LocalDateTime.class, (Type)PrimitiveType.Datetime);
        this.typeByClass.put(Time.class, (Type)PrimitiveType.Datetime);
        this.typeByClass.put(LocalTime.class, (Type)PrimitiveType.Datetime);
        this.typeByClass.put(Timestamp.class, (Type)PrimitiveType.Timestamp);
        this.typeByClass.put(Instant.class, (Type)PrimitiveType.Timestamp);
        this.typeByClass.put(DecimalValue.class, (Type)DEFAULT_DECIMAL_TYPE);
        this.typeByClass.put(BigDecimal.class, (Type)DEFAULT_DECIMAL_TYPE);
        this.typeByClass.put(Duration.class, (Type)PrimitiveType.Interval);
        this.sqlTypeByPrimitiveNumId = new HashMap<PrimitiveType, Integer>(values.length);
        for (PrimitiveType id : values) {
            int sqlType;
            switch (id) {
                case Text: 
                case Json: 
                case JsonDocument: 
                case Uuid: {
                    sqlType = 12;
                    break;
                }
                case Bytes: 
                case Yson: {
                    sqlType = -2;
                    break;
                }
                case Bool: {
                    sqlType = 16;
                    break;
                }
                case Int8: 
                case Int16: {
                    sqlType = 5;
                    break;
                }
                case Uint8: 
                case Int32: 
                case Uint16: {
                    sqlType = 4;
                    break;
                }
                case Uint32: 
                case Int64: 
                case Uint64: 
                case Interval: {
                    sqlType = -5;
                    break;
                }
                case Float: {
                    sqlType = 6;
                    break;
                }
                case Double: {
                    sqlType = 8;
                    break;
                }
                case Date: {
                    sqlType = 91;
                    break;
                }
                case Datetime: {
                    sqlType = 92;
                    break;
                }
                case Timestamp: {
                    sqlType = 93;
                    break;
                }
                case TzDate: 
                case TzDatetime: 
                case TzTimestamp: {
                    sqlType = 2014;
                    break;
                }
                default: {
                    sqlType = 2000;
                }
            }
            this.sqlTypeByPrimitiveNumId.put(id, sqlType);
        }
        this.selfValidate();
    }

    private void selfValidate() {
        for (Map.Entry<PrimitiveType, Integer> entry : this.sqlTypeByPrimitiveNumId.entrySet()) {
            int sqlType = entry.getValue();
            if (sqlType == 2000 || this.typeBySqlType.containsKey(sqlType)) continue;
            throw new IllegalStateException("Internal error. SQL type " + sqlType + " by YDB type id " + entry.getKey() + " is not registered in #typeBySqlType");
        }
    }

    @Override
    public int toWrappedSqlType(Class<?> type) {
        Type result = this.typeByClass.get(type);
        if (result != null) {
            return this.wrapYdbJdbcType(result);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Type toYdbType(Class<?> type) {
        return this.toYdbType(this.toWrappedSqlType(type));
    }

    @Override
    public int wrapYdbJdbcType(Type type) {
        if (type.getKind() == Type.Kind.PRIMITIVE) {
            return 10000 + ((PrimitiveType)type).ordinal();
        }
        if (type.getKind() == Type.Kind.DECIMAL) {
            return 3;
        }
        if (type.getKind() == Type.Kind.OPTIONAL) {
            return this.wrapYdbJdbcType(type.unwrapOptional());
        }
        return 2000;
    }

    @Override
    public int unwrapYdbJdbcType(int sqlType) {
        if (sqlType >= 10000 && sqlType < 32768) {
            int idType = sqlType - 10000;
            PrimitiveType type = PrimitiveType.values()[idType];
            Integer value = this.sqlTypeByPrimitiveNumId.get(type);
            if (value == null) {
                throw new RuntimeException("Internal error. Unsupported YDB type: " + idType + " as " + type);
            }
            return value;
        }
        return sqlType;
    }

    @Override
    @Nullable
    public Type toYdbType(int sqlType) {
        if (sqlType == Integer.MIN_VALUE) {
            return null;
        }
        if (sqlType >= 10000 && sqlType < 32768) {
            int idType = sqlType - 10000;
            return PrimitiveType.values()[idType];
        }
        if (sqlType == 32768 || sqlType == 3) {
            return DEFAULT_DECIMAL_TYPE;
        }
        return (Type)this.typeBySqlType.get(sqlType);
    }

    @Override
    @Nullable
    public Type toYdbType(String typeName) {
        if (typeName.endsWith("?")) {
            Type type = this.typeByTypeName.get(typeName.substring(0, typeName.length() - "?".length()));
            return type != null ? type.makeOptional() : null;
        }
        return this.typeByTypeName.get(typeName);
    }

    @Override
    public int toSqlType(Type type) {
        return this.unwrapYdbJdbcType(this.wrapYdbJdbcType(type));
    }

    @Override
    public int getSqlPrecision(Type type) {
        switch (type.getKind()) {
            case OPTIONAL: {
                return this.getSqlPrecision(type.unwrapOptional());
            }
            case DECIMAL: {
                return 16;
            }
            case PRIMITIVE: {
                return this.getSqlPrecision((PrimitiveType)type);
            }
        }
        return 0;
    }

    @Override
    public Collection<Integer> getSqlTypes() {
        return Collections.unmodifiableSet(this.typeBySqlType.keySet());
    }

    @Override
    public List<Type> getAllDatabaseTypes() {
        return Arrays.asList(PrimitiveType.Bool, PrimitiveType.Int8, PrimitiveType.Int16, PrimitiveType.Int32, PrimitiveType.Int64, PrimitiveType.Uint8, PrimitiveType.Uint16, PrimitiveType.Uint32, PrimitiveType.Uint64, PrimitiveType.Float, PrimitiveType.Double, PrimitiveType.Bytes, PrimitiveType.Text, PrimitiveType.Json, PrimitiveType.JsonDocument, PrimitiveType.Yson, PrimitiveType.Date, PrimitiveType.Datetime, PrimitiveType.Timestamp, PrimitiveType.Interval, YdbTypes.DEFAULT_DECIMAL_TYPE);
    }

    private int getSqlPrecision(PrimitiveType type) {
        switch (type) {
            case Bool: 
            case Int8: 
            case Uint8: {
                return 1;
            }
            case Int16: 
            case Uint16: {
                return 2;
            }
            case Int32: 
            case Uint32: 
            case Float: {
                return 4;
            }
            case Int64: 
            case Uint64: 
            case Interval: 
            case Double: {
                return 8;
            }
            case Text: 
            case Json: 
            case JsonDocument: 
            case Bytes: 
            case Yson: {
                return 0x400000;
            }
            case Uuid: {
                return 16;
            }
            case Date: {
                return "0000-00-00".length();
            }
            case Datetime: {
                return "0000-00-00 00:00:00".length();
            }
            case Timestamp: {
                return "0000-00-00T00:00:00.000000".length();
            }
            case TzDate: {
                return "0000-00-00+00:00".length();
            }
            case TzDatetime: {
                return "0000-00-00 00:00:00+00:00".length();
            }
            case TzTimestamp: {
                return "0000-00-00T00:00:00.000000+00:00".length();
            }
        }
        return 0;
    }

    public static YdbTypes getInstance() {
        return INSTANCE;
    }
}

