/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.impl.BaseYdbStatement;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.table.query.Params;

public class YdbStatementImpl
extends BaseYdbStatement {
    private static final Logger LOGGER = Logger.getLogger(YdbStatementImpl.class.getName());
    private final List<String> batch = new ArrayList<String>();

    public YdbStatementImpl(YdbConnection connection, int resultSetType) {
        super(LOGGER, connection, resultSetType, false);
    }

    @Override
    public void executeSchemeQuery(String sql) throws SQLException {
        this.cleanState();
        this.clearBatch();
        YdbQuery query = this.getConnection().getCtx().parseYdbQuery(sql);
        this.executeSchemeQuery(query);
    }

    @Override
    public YdbResultSet executeScanQuery(String sql) throws SQLException {
        this.cleanState();
        this.clearBatch();
        YdbQuery query = this.getConnection().getCtx().parseYdbQuery(sql);
        List<BaseYdbStatement.YdbResult> results = this.executeScanQuery(query, Params.empty());
        if (!this.updateState(results)) {
            throw new SQLException("Query must return ResultSet");
        }
        return this.getResultSet();
    }

    @Override
    public YdbResultSet executeExplainQuery(String sql) throws SQLException {
        this.cleanState();
        this.clearBatch();
        YdbQuery query = this.getConnection().getCtx().parseYdbQuery(sql);
        List<BaseYdbStatement.YdbResult> newState = this.executeExplainQuery(query);
        if (!this.updateState(newState)) {
            throw new SQLException("Query must return ResultSet");
        }
        return this.getResultSet();
    }

    @Override
    public YdbResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("Query must return ResultSet");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("Query must not return ResultSet");
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.cleanState();
        YdbQuery query = this.getConnection().getCtx().parseYdbQuery(sql);
        List<BaseYdbStatement.YdbResult> newState = null;
        switch (query.type()) {
            case SCHEME_QUERY: {
                newState = this.executeSchemeQuery(query);
                break;
            }
            case DATA_QUERY: {
                newState = this.executeDataQuery(query, Params.empty());
                break;
            }
            case SCAN_QUERY: {
                newState = this.executeScanQuery(query, Params.empty());
                break;
            }
            case EXPLAIN_QUERY: {
                newState = this.executeExplainQuery(query);
                break;
            }
            default: {
                throw new IllegalStateException("Internal error. Unsupported query type " + (Object)((Object)query.type()));
            }
        }
        return this.updateState(newState);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.cleanState();
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.cleanState();
        if (this.batch.isEmpty()) {
            LOGGER.log(Level.FINE, "Batch is empty, nothing to execute");
            return new int[0];
        }
        try {
            LOGGER.log(Level.FINE, "Executing batch of {0} item(s)", this.batch.size());
            String sql = String.join((CharSequence)";\n", this.batch);
            this.execute(sql);
            int[] ret = new int[this.batch.size()];
            Arrays.fill(ret, -2);
            int[] nArray = ret;
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
        }
        return this.execute(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

