/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.common.FixedResultSetFactory;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.impl.YdbResultSetImpl;
import tech.ydb.jdbc.query.ExplainedQuery;
import tech.ydb.jdbc.query.YdbExpression;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;

public abstract class BaseYdbStatement
implements YdbStatement {
    private static final ResultState EMPTY_STATE = new ResultState(null);
    private static final YdbResult NO_UPDATED = new YdbResult(0);
    private static final YdbResult HAS_UPDATED = new YdbResult(1);
    private static final FixedResultSetFactory EXPLAIN_RS_FACTORY = FixedResultSetFactory.newBuilder().addTextColumn("AST").addTextColumn("PLAN").build();
    private final YdbConnection connection;
    private final YdbValidator validator;
    private final int resultSetType;
    private final int maxRows;
    private final boolean failOnTruncatedResult;
    private ResultState state = EMPTY_STATE;
    private int queryTimeout;
    private boolean isPoolable;
    private boolean isClosed = false;

    public BaseYdbStatement(Logger logger, YdbConnection connection, int resultSetType, boolean isPoolable) {
        this.connection = Objects.requireNonNull(connection);
        this.validator = new YdbValidator(logger);
        this.resultSetType = resultSetType;
        this.isPoolable = isPoolable;
        YdbOperationProperties props = connection.getCtx().getOperationProperties();
        this.queryTimeout = (int)props.getQueryTimeout().getSeconds();
        this.maxRows = props.getMaxRows();
        this.failOnTruncatedResult = props.isFailOnTruncatedResult();
    }

    @Override
    public YdbConnection getConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.validator.toSQLWarnings();
    }

    @Override
    public void clearWarnings() {
        this.validator.clearWarnings();
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ensureOpened();
        this.queryTimeout = seconds;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.isPoolable = poolable;
    }

    @Override
    public boolean isPoolable() {
        return this.isPoolable;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public YdbResultSet getResultSet() throws SQLException {
        this.ensureOpened();
        return this.state.getCurrentResultSet();
    }

    @Override
    public YdbResultSet getResultSetAt(int resultSetIndex) throws SQLException {
        this.ensureOpened();
        return this.state.getResultSet(resultSetIndex);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.ensureOpened();
        return this.state.getMoreResults(current);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureOpened();
        return this.state.getUpdateCount();
    }

    private void ensureOpened() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    protected void cleanState() throws SQLException {
        this.ensureOpened();
        this.clearWarnings();
        this.state = EMPTY_STATE;
    }

    protected boolean updateState(List<YdbResult> results) {
        this.state = results == null ? EMPTY_STATE : new ResultState(results);
        return this.state.hasResultSets();
    }

    protected List<YdbResult> executeSchemeQuery(YdbQuery query) throws SQLException {
        this.connection.executeSchemeQuery(query, this.validator);
        int expressionsCount = query.getExpressions().isEmpty() ? 1 : query.getExpressions().size();
        ArrayList<YdbResult> results = new ArrayList<YdbResult>();
        for (int i = 0; i < expressionsCount; ++i) {
            results.add(NO_UPDATED);
        }
        return results;
    }

    protected List<YdbResult> executeExplainQuery(YdbQuery query) throws SQLException {
        ExplainedQuery explainedQuery = this.connection.executeExplainQuery(query, this.validator);
        ResultSetReader result = EXPLAIN_RS_FACTORY.createResultSet().newRow().withTextValue("AST", explainedQuery.getAst()).withTextValue("PLAN", explainedQuery.getPlan()).build().build();
        return Collections.singletonList(new YdbResult(new YdbResultSetImpl(this, result)));
    }

    protected List<YdbResult> executeScanQuery(YdbQuery query, Params params) throws SQLException {
        ResultSetReader result = this.connection.executeScanQuery(query, this.validator, params);
        return Collections.singletonList(new YdbResult(new YdbResultSetImpl(this, result)));
    }

    protected List<YdbResult> executeDataQuery(YdbQuery query, Params params) throws SQLException {
        List<ResultSetReader> resultSets = this.connection.executeDataQuery(query, this.validator, this.getQueryTimeout(), this.isPoolable(), params);
        ArrayList<YdbResult> results = new ArrayList<YdbResult>();
        int idx = 0;
        for (YdbExpression exp : query.getExpressions()) {
            if (exp.isDDL()) {
                results.add(NO_UPDATED);
                continue;
            }
            if (!exp.isSelect()) {
                results.add(HAS_UPDATED);
                continue;
            }
            if (idx >= resultSets.size()) continue;
            ResultSetReader rs = resultSets.get(idx);
            if (this.failOnTruncatedResult && rs.isTruncated()) {
                String msg = String.format("Result #%s was truncated to %s rows", idx, rs.getRowCount());
                throw new SQLException(msg);
            }
            results.add(new YdbResult(new YdbResultSetImpl(this, rs)));
            ++idx;
        }
        while (idx < resultSets.size()) {
            ResultSetReader rs = resultSets.get(idx);
            if (this.failOnTruncatedResult && rs.isTruncated()) {
                String msg = String.format("Result #%s was truncated to %s rows", idx, rs.getRowCount());
                throw new SQLException(msg);
            }
            results.add(new YdbResult(new YdbResultSetImpl(this, rs)));
            ++idx;
        }
        return results;
    }

    @Override
    public void setCursorName(String name) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Named cursors are not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureOpened();
        return this.getMoreResults(2);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1002) {
            throw new SQLException("Direction is not supported: " + direction);
        }
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return this.getMaxRows();
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    private static class ResultState {
        private final List<YdbResult> results;
        private int resultIndex;

        ResultState(List<YdbResult> results) {
            this.results = results;
            this.resultIndex = 0;
        }

        boolean hasResultSets() {
            if (this.results == null || this.resultIndex >= this.results.size()) {
                return false;
            }
            return this.results.get(this.resultIndex).resultSet != null;
        }

        int getUpdateCount() {
            if (this.results == null || this.resultIndex >= this.results.size()) {
                return -1;
            }
            return this.results.get(this.resultIndex).updateCount;
        }

        YdbResultSet getCurrentResultSet() {
            if (this.results == null || this.resultIndex >= this.results.size()) {
                return null;
            }
            return this.results.get(this.resultIndex).resultSet;
        }

        YdbResultSet getResultSet(int index) {
            if (this.results == null || index < 0 || index >= this.results.size()) {
                return null;
            }
            return this.results.get(index).resultSet;
        }

        boolean getMoreResults(int current) throws SQLException {
            if (this.results == null || this.resultIndex >= this.results.size()) {
                return false;
            }
            switch (current) {
                case 2: {
                    break;
                }
                case 1: {
                    this.results.get(this.resultIndex).resultSet.close();
                    break;
                }
                case 3: {
                    for (int idx = 0; idx <= this.resultIndex; ++idx) {
                        this.results.get(idx).resultSet.close();
                    }
                    break;
                }
                default: {
                    throw new SQLException("ResultSet mode is not supported: " + current);
                }
            }
            ++this.resultIndex;
            return this.hasResultSets();
        }
    }

    protected static class YdbResult {
        private final int updateCount;
        private final YdbResultSet resultSet;

        YdbResult(int updateCount) {
            this.updateCount = updateCount;
            this.resultSet = null;
        }

        YdbResult(YdbResultSet resultSet) {
            this.updateCount = -1;
            this.resultSet = resultSet;
        }
    }
}

