/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import tech.ydb.jdbc.common.MappingGetters;
import tech.ydb.jdbc.common.MappingSetters;
import tech.ydb.table.values.DecimalType;
import tech.ydb.table.values.OptionalType;
import tech.ydb.table.values.OptionalValue;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;

public class TypeDescription {
    private static final Map<Type, TypeDescription> TYPES = new ConcurrentHashMap<Type, TypeDescription>();
    private final Type type;
    private final boolean optional;
    private final OptionalValue optionalValue;
    private final MappingGetters.Getters getters;
    private final MappingSetters.Setters setters;
    private final MappingGetters.SqlType sqlType;

    private TypeDescription(Type type, OptionalValue optionalValue, MappingGetters.Getters getters, MappingSetters.Setters setters, MappingGetters.SqlType sqlType) {
        this.type = Objects.requireNonNull(type);
        this.optional = optionalValue != null;
        this.optionalValue = optionalValue;
        this.getters = Objects.requireNonNull(getters);
        this.setters = Objects.requireNonNull(setters);
        this.sqlType = Objects.requireNonNull(sqlType);
    }

    public boolean isNullType() {
        return this.type.getKind() == Type.Kind.NULL || this.type.getKind() == Type.Kind.VOID;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public OptionalValue nullValue() {
        return this.optionalValue;
    }

    public MappingGetters.SqlType sqlType() {
        return this.sqlType;
    }

    public MappingGetters.Getters getters() {
        return this.getters;
    }

    public MappingSetters.Setters setters() {
        return this.setters;
    }

    public Type ydbType() {
        return this.type;
    }

    private static void ofInternal(Type type) {
        TypeDescription.of(type);
        TypeDescription.of((Type)type.makeOptional());
    }

    private static TypeDescription buildType(Type origType) {
        OptionalValue optionalValue;
        Type type;
        if (origType.getKind() == Type.Kind.OPTIONAL) {
            OptionalType optionalType = (OptionalType)origType;
            type = optionalType.getItemType();
            optionalValue = optionalType.emptyValue();
        } else {
            type = origType;
            optionalValue = null;
        }
        MappingGetters.Getters getters = MappingGetters.buildGetters(type);
        MappingSetters.Setters setters = MappingSetters.buildSetters(type);
        MappingGetters.SqlType sqlTypes = MappingGetters.buildDataType(type);
        return new TypeDescription(type, optionalValue, getters, setters, sqlTypes);
    }

    public static TypeDescription of(Type type) {
        return TYPES.computeIfAbsent(type, TypeDescription::buildType);
    }

    static {
        TypeDescription.ofInternal((Type)DecimalType.of((int)35));
        TypeDescription.ofInternal((Type)DecimalType.of((int)22, (int)9));
        for (PrimitiveType type : PrimitiveType.values()) {
            TypeDescription.ofInternal((Type)type);
        }
    }
}

