/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.provider;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import yandex.cloud.sdk.auth.IamToken;
import yandex.cloud.sdk.auth.provider.CredentialProvider;
import yandex.cloud.sdk.auth.provider.UnavailableIamTokenException;

class BackgroundUpdatingCredentialProvider
implements CredentialProvider {
    private final CredentialProvider delegate;
    private final long delay;
    private final double jitter;
    private final ScheduledExecutorService updateScheduler;
    private volatile transient IamToken iamToken = new IamToken("", Instant.MIN);

    BackgroundUpdatingCredentialProvider(CredentialProvider provider, long delay, double jitter, ScheduledExecutorService updateScheduler) {
        this.delegate = provider;
        this.delay = delay;
        this.jitter = jitter;
        this.updateScheduler = updateScheduler;
        this.updateAndScheduleNext();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public IamToken get() {
        if (Instant.now().isBefore(this.iamToken.getExpiresAt())) {
            return this.iamToken;
        }
        throw new UnavailableIamTokenException("IAM token is expired");
    }

    private void updateAndScheduleNext() {
        Duration nextUpdate;
        try {
            IamToken iamToken;
            this.iamToken = iamToken = this.delegate.get();
            nextUpdate = Duration.between(Instant.now(), iamToken.getUpdateAt());
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw e;
            }
            nextUpdate = Duration.ofMillis((long)((double)this.delay * (1.0 + this.jitter * (Math.random() * 2.0 - 1.0))));
        }
        this.updateScheduler.schedule(this::updateAndScheduleNext, nextUpdate.toNanos(), TimeUnit.NANOSECONDS);
    }
}

