/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import yandex.cloud.sdk.auth.metadata.HttpConnectionConfig;
import yandex.cloud.sdk.auth.metadata.MalformedURLException;
import yandex.cloud.sdk.auth.metadata.MetadataException;

public class InstanceMetadataService {
    public static final String METADATA_SERVER_URL = "http://169.254.169.254";
    private static final String METADATA_PATH_PREFIX = "/computeMetadata/v1/";
    private final HttpConnectionConfig config;
    private final URI metadataServerUrl;

    public InstanceMetadataService() {
        this(HttpConnectionConfig.DEFAULT);
    }

    public InstanceMetadataService(HttpConnectionConfig config) {
        this(config, METADATA_SERVER_URL);
    }

    public InstanceMetadataService(HttpConnectionConfig config, String metadataServerUrl) {
        this.config = config;
        try {
            URL url = new URL(metadataServerUrl + METADATA_PATH_PREFIX);
            this.metadataServerUrl = url.toURI();
        }
        catch (java.net.MalformedURLException | URISyntaxException e) {
            throw new MalformedURLException(metadataServerUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String key) throws IOException {
        HttpURLConnection connection = null;
        try {
            String response;
            URI fullUrl = null;
            try {
                fullUrl = this.metadataServerUrl.resolve(key);
                connection = (HttpURLConnection)fullUrl.toURL().openConnection();
            }
            catch (java.net.MalformedURLException e) {
                throw new MalformedURLException(fullUrl.getPath());
            }
            try {
                connection.setRequestMethod("GET");
            }
            catch (ProtocolException e) {
                throw new MetadataException(key, e);
            }
            connection.setConnectTimeout(this.config.getConnectTimeoutMs());
            connection.setReadTimeout(this.config.getReadTimeoutMs());
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty("Metadata-Flavor", "Google");
            int status = connection.getResponseCode();
            if (status != 200) {
                throw new RuntimeException("Error retrieving metadata: " + status);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                response = content.toString();
            }
            String string = response;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

