/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.jwt;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import tech.ydb.shaded.jackson.annotation.JsonCreator;
import tech.ydb.shaded.jackson.annotation.JsonProperty;
import yandex.cloud.sdk.auth.jwt.SecurityUtils;

public class ServiceAccountKey {
    private final String keyId;
    private final String serviceAccountId;
    private final String createdAt;
    private final String keyAlgorithm;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    @JsonCreator
    public ServiceAccountKey(@JsonProperty(value="id") String keyId, @JsonProperty(value="service_account_id") String serviceAccountId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="key_algorithm") String keyAlgorithm, @JsonProperty(value="public_key") String publicKey, @JsonProperty(value="private_key") String privateKey) {
        this.keyId = keyId;
        this.serviceAccountId = serviceAccountId;
        this.createdAt = createdAt;
        this.keyAlgorithm = keyAlgorithm;
        this.publicKey = SecurityUtils.createRsaPublicKey(publicKey);
        this.privateKey = SecurityUtils.createRsaPrivateKey(privateKey);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getServiceAccountId() {
        return this.serviceAccountId;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountKey that = (ServiceAccountKey)o;
        return Objects.equals(this.keyId, that.keyId) && Objects.equals(this.serviceAccountId, that.serviceAccountId) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.keyAlgorithm, that.keyAlgorithm) && Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.privateKey, that.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.keyId, this.serviceAccountId, this.createdAt, this.keyAlgorithm, this.publicKey, this.privateKey);
    }

    public String toString() {
        return "ServiceAccountKey{keyId='" + this.keyId + '\'' + ", serviceAccountId='" + this.serviceAccountId + '\'' + ", createdAt='" + this.createdAt + '\'' + ", keyAlgorithm='" + this.keyAlgorithm + '\'' + ", publicKey=" + this.publicKey + '}';
    }
}

