/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.jwt;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import tech.ydb.shaded.io.jsonwebtoken.JwtBuilder;
import tech.ydb.shaded.io.jsonwebtoken.Jwts;
import tech.ydb.shaded.io.jsonwebtoken.SignatureAlgorithm;
import yandex.cloud.sdk.auth.jwt.Jwt;
import yandex.cloud.sdk.auth.jwt.JwtConfig;
import yandex.cloud.sdk.auth.jwt.ServiceAccountKey;

public class JwtCreator {
    private static final String DEFAUL_ENDPOINT = "https://iam.api.cloud.yandex.net/iam/v1/tokens";
    private static final Duration DEFAULT_TTL = Duration.ofHours(1L);
    private final String endpoint;
    private final Duration ttl;

    public JwtCreator() {
        this.endpoint = DEFAUL_ENDPOINT;
        this.ttl = DEFAULT_TTL;
    }

    public JwtCreator(JwtConfig config) {
        this.endpoint = config.getEndpoint() != null ? config.getEndpoint() : DEFAUL_ENDPOINT;
        this.ttl = config.getTtl() != null ? config.getTtl() : DEFAULT_TTL;
    }

    public Jwt generateJwt(ServiceAccountKey serviceAccountKey) {
        return this.generateJwt(serviceAccountKey, this.ttl);
    }

    public Jwt generateJwt(ServiceAccountKey serviceAccountKey, Duration ttl) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.PS256;
        Instant curInstant = Instant.now();
        Instant exp = curInstant.plus(ttl);
        JwtBuilder builder = Jwts.builder().setIssuer(serviceAccountKey.getServiceAccountId()).setIssuedAt(Date.from(curInstant)).setExpiration(Date.from(exp)).setAudience(this.endpoint).signWith(serviceAccountKey.getPrivateKey(), signatureAlgorithm);
        builder.setHeaderParam("kid", serviceAccountKey.getKeyId());
        return new Jwt(builder.compact(), exp);
    }
}

