/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.ydb.proto.ValueProtos;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.google.common.collect.Maps;
import tech.ydb.table.utils.Arrays2;
import tech.ydb.table.values.StructValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public final class StructType
implements Type {
    private final String[] names;
    private final Type[] types;
    private final Map<String, Integer> namesIdx;

    StructType(String[] names, Type[] types) {
        if (names.length == 0 || types.length == 0) {
            throw new IllegalStateException("names or types cannot be empty");
        }
        if (names.length != types.length) {
            throw new IllegalStateException("names and types count mismatch");
        }
        Arrays2.sortBothByFirst((Comparable[])names, (Object[])types);
        this.names = names;
        this.types = types;
        this.namesIdx = StructType.buildNamesIdx(names);
    }

    public static StructType of(String memberName, Type memberType) {
        return new StructType(new String[]{memberName}, new Type[]{memberType});
    }

    public static StructType of(String member1Name, Type member1Type, String member2Name, Type member2Type) {
        return new StructType(new String[]{member1Name, member2Name}, new Type[]{member1Type, member2Type});
    }

    public static StructType of(String member1Name, Type member1Type, String member2Name, Type member2Type, String member3Name, Type member3Type) {
        return new StructType(new String[]{member1Name, member2Name, member3Name}, new Type[]{member1Type, member2Type, member3Type});
    }

    public static StructType of(String member1Name, Type member1Type, String member2Name, Type member2Type, String member3Name, Type member3Type, String member4Name, Type member4Type) {
        return new StructType(new String[]{member1Name, member2Name, member3Name, member4Name}, new Type[]{member1Type, member2Type, member3Type, member4Type});
    }

    public static StructType of(String member1Name, Type member1Type, String member2Name, Type member2Type, String member3Name, Type member3Type, String member4Name, Type member4Type, String member5Name, Type member5Type) {
        return new StructType(new String[]{member1Name, member2Name, member3Name, member4Name, member5Name}, new Type[]{member1Type, member2Type, member3Type, member4Type, member5Type});
    }

    public static StructType of(Map<String, Type> members) {
        int size = members.size();
        String[] names = new String[size];
        Type[] types = new Type[size];
        int i = 0;
        for (Map.Entry<String, Type> e : members.entrySet()) {
            names[i] = e.getKey();
            types[i] = e.getValue();
            ++i;
        }
        return new StructType(names, types);
    }

    public static StructType of(List<String> names, List<Type> types) {
        String[] namesArray = names.toArray(new String[0]);
        Type[] typesArray = types.toArray(Type.EMPTY_ARRAY);
        return new StructType(namesArray, typesArray);
    }

    public static StructType ofCopy(String[] names, Type[] types) {
        return new StructType((String[])names.clone(), (Type[])types.clone());
    }

    public static StructType ofOwn(String[] names, Type[] types) {
        return new StructType(names, types);
    }

    public int getMembersCount() {
        return this.names.length;
    }

    public String getMemberName(int index) {
        return this.names[index];
    }

    public Type getMemberType(int index) {
        return this.types[index];
    }

    public int getMemberIndex(String name) {
        Integer index = this.namesIdx.get(name);
        return index == null ? -1 : index;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.STRUCT;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructType structType = (StructType)o;
        if (this.getMembersCount() != structType.getMembersCount()) {
            return false;
        }
        for (int i = 0; i < this.getMembersCount(); ++i) {
            if (!this.getMemberName(i).equals(structType.getMemberName(i))) {
                return false;
            }
            if (this.getMemberType(i).equals(structType.getMemberType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = Type.Kind.STRUCT.hashCode();
        result = 31 * result + Arrays.hashCode(this.names);
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Struct<");
        for (int i = 0; i < this.names.length; ++i) {
            sb.append('\'').append(this.names[i]).append('\'');
            sb.append(": ").append(this.types[i]).append(", ");
        }
        if (this.names.length != 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public ValueProtos.Type toPb() {
        ValueProtos.StructType.Builder structType = ValueProtos.StructType.newBuilder();
        for (int i = 0; i < this.names.length; ++i) {
            structType.addMembersBuilder().setName(this.names[i]).setType(this.types[i].toPb());
        }
        return ValueProtos.Type.newBuilder().setStructType(structType).build();
    }

    public StructValue newValue(String memberName, Value<?> memberValue) {
        Preconditions.checkArgument(this.getMembersCount() == 1, "struct type %s has different members count", (Object)this);
        Preconditions.checkArgument(this.getMemberName(0).equals(memberName), "struct type %s has no member %s", (Object)this, memberValue);
        return new StructValue(this, memberValue);
    }

    public StructValue newValue(String member1Name, Value<?> member1Value, String member2Name, Value<?> member2Value) {
        Preconditions.checkArgument(this.getMembersCount() == 2, "struct type %s has different members count", (Object)this);
        Value[] values = new Value[2];
        this.setValue(values, member1Name, member1Value);
        this.setValue(values, member2Name, member2Value);
        return new StructValue(this, values);
    }

    public StructValue newValue(String member1Name, Value<?> member1Value, String member2Name, Value<?> member2Value, String member3Name, Value<?> member3Value) {
        Preconditions.checkArgument(this.getMembersCount() == 3, "struct type %s has different members count", (Object)this);
        Value[] values = new Value[3];
        this.setValue(values, member1Name, member1Value);
        this.setValue(values, member2Name, member2Value);
        this.setValue(values, member3Name, member3Value);
        return new StructValue(this, values);
    }

    public StructValue newValue(String member1Name, Value<?> member1Value, String member2Name, Value<?> member2Value, String member3Name, Value<?> member3Value, String member4Name, Value<?> member4Value) {
        Preconditions.checkArgument(this.getMembersCount() == 4, "struct type %s has different members count", (Object)this);
        Value[] values = new Value[4];
        this.setValue(values, member1Name, member1Value);
        this.setValue(values, member2Name, member2Value);
        this.setValue(values, member3Name, member3Value);
        this.setValue(values, member4Name, member4Value);
        return new StructValue(this, values);
    }

    public StructValue newValue(String member1Name, Value<?> member1Value, String member2Name, Value<?> member2Value, String member3Name, Value<?> member3Value, String member4Name, Value<?> member4Value, String member5Name, Value<?> member5Value) {
        Preconditions.checkArgument(this.getMembersCount() == 5, "struct type %s has different members count", (Object)this);
        Value[] values = new Value[5];
        this.setValue(values, member1Name, member1Value);
        this.setValue(values, member2Name, member2Value);
        this.setValue(values, member3Name, member3Value);
        this.setValue(values, member4Name, member4Value);
        this.setValue(values, member5Name, member5Value);
        return new StructValue(this, values);
    }

    private void setValue(Value<?>[] values, String name, Value<?> value) {
        int idx = this.getMemberIndex(name);
        Preconditions.checkArgument(idx != -1, "struct type %s has no member %s", (Object)this, (Object)name);
        values[idx] = value;
    }

    public StructValue newValue(Map<String, Value<?>> membersMap) {
        Preconditions.checkArgument(this.getMembersCount() == membersMap.size(), "incompatible struct type %s and values names %s", (Object)this, membersMap.keySet());
        Value[] members = new Value[membersMap.size()];
        for (int i = 0; i < this.getMembersCount(); ++i) {
            String name = this.getMemberName(i);
            Value<?> value = membersMap.get(name);
            Preconditions.checkArgument(value != null, "given map %s has no member with name %s", membersMap.keySet(), (Object)name);
            members[i] = value;
        }
        return new StructValue(this, members);
    }

    public StructValue newValueUnsafe(Value<?> ... members) {
        return new StructValue(this, members);
    }

    private static Map<String, Integer> buildNamesIdx(String[] names) {
        HashMap<String, Integer> namesIdx = Maps.newHashMapWithExpectedSize(names.length);
        for (int i = 0; i < names.length; ++i) {
            if (namesIdx.put(names[i], i) == null) continue;
            throw new IllegalArgumentException("duplicate member name in struct: " + names[i]);
        }
        return namesIdx;
    }
}

