/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import tech.ydb.proto.ValueProtos;
import tech.ydb.shaded.google.common.escape.Escaper;
import tech.ydb.shaded.google.common.escape.Escapers;
import tech.ydb.shaded.google.protobuf.ByteString;
import tech.ydb.shaded.google.protobuf.UnsafeByteOperations;
import tech.ydb.table.utils.LittleEndian;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.proto.ProtoValue;

public abstract class PrimitiveValue
implements Value<PrimitiveType> {
    public boolean getBool() {
        throw new IllegalStateException("expected Bool, but was " + this.getClass().getSimpleName());
    }

    public byte getInt8() {
        throw new IllegalStateException("expected Int8, but was " + this.getClass().getSimpleName());
    }

    public int getUint8() {
        throw new IllegalStateException("expected Uint8, but was " + this.getClass().getSimpleName());
    }

    public short getInt16() {
        throw new IllegalStateException("expected Int16, but was " + this.getClass().getSimpleName());
    }

    public int getUint16() {
        throw new IllegalStateException("expected Uint16, but was " + this.getClass().getSimpleName());
    }

    public int getInt32() {
        throw new IllegalStateException("expected Int32, but was " + this.getClass().getSimpleName());
    }

    public long getUint32() {
        throw new IllegalStateException("expected Uint32, but was " + this.getClass().getSimpleName());
    }

    public long getInt64() {
        throw new IllegalStateException("expected Int64, but was " + this.getClass().getSimpleName());
    }

    public long getUint64() {
        throw new IllegalStateException("expected Uint64, but was " + this.getClass().getSimpleName());
    }

    public float getFloat() {
        throw new IllegalStateException("expected Float, but was " + this.getClass().getSimpleName());
    }

    public double getDouble() {
        throw new IllegalStateException("expected Double, but was " + this.getClass().getSimpleName());
    }

    public byte[] getBytes() {
        throw new IllegalStateException("expected Bytes, but was " + this.getClass().getSimpleName());
    }

    public byte[] getBytesUnsafe() {
        throw new IllegalStateException("expected Bytes, but was " + this.getClass().getSimpleName());
    }

    public ByteString getBytesAsByteString() {
        throw new IllegalStateException("expected String, but was " + this.getClass().getSimpleName());
    }

    public String getBytesAsString(Charset charset) {
        return new String(this.getBytesUnsafe(), charset);
    }

    public String getText() {
        throw new IllegalStateException("expected Utf8, but was " + this.getClass().getSimpleName());
    }

    public byte[] getYson() {
        throw new IllegalStateException("expected Yson, but was " + this.getClass().getSimpleName());
    }

    public byte[] getYsonUnsafe() {
        throw new IllegalStateException("expected Yson, but was " + this.getClass().getSimpleName());
    }

    public ByteString getYsonBytes() {
        throw new IllegalStateException("expected Yson, but was " + this.getClass().getSimpleName());
    }

    public String getJson() {
        throw new IllegalStateException("expected Json, but was " + this.getClass().getSimpleName());
    }

    public String getJsonDocument() {
        throw new IllegalStateException("expected JsonDocument, but was " + this.getClass().getSimpleName());
    }

    public String getUuidString() {
        throw new IllegalStateException("expected Uuid, but was " + this.getClass().getSimpleName());
    }

    public long getUuidHigh() {
        throw new IllegalStateException("expected Uuid, but was " + this.getClass().getSimpleName());
    }

    public long getUuidLow() {
        throw new IllegalStateException("expected Uuid, but was " + this.getClass().getSimpleName());
    }

    public UUID getUuidJdk() {
        throw new IllegalStateException("expected Uuid, but was " + this.getClass().getSimpleName());
    }

    public LocalDate getDate() {
        throw new IllegalStateException("expected Date, but was " + this.getClass().getSimpleName());
    }

    public LocalDateTime getDatetime() {
        throw new IllegalStateException("expected Datetime, but was " + this.getClass().getSimpleName());
    }

    public Instant getTimestamp() {
        throw new IllegalStateException("expected Timestamp, but was " + this.getClass().getSimpleName());
    }

    public Duration getInterval() {
        throw new IllegalStateException("expected Interval, but was " + this.getClass().getSimpleName());
    }

    public ZonedDateTime getTzDate() {
        throw new IllegalStateException("expected TzDate, but was " + this.getClass().getSimpleName());
    }

    public ZonedDateTime getTzDatetime() {
        throw new IllegalStateException("expected TzDatetime, but was " + this.getClass().getSimpleName());
    }

    public ZonedDateTime getTzTimestamp() {
        throw new IllegalStateException("expected TzTimestamp, but was " + this.getClass().getSimpleName());
    }

    public static PrimitiveValue newBool(boolean value) {
        return value ? Bool.TRUE : Bool.FALSE;
    }

    public static PrimitiveValue newInt8(byte value) {
        return new Int8(value);
    }

    public static PrimitiveValue newUint8(int value) {
        return new Uint8(value);
    }

    public static PrimitiveValue newInt16(short value) {
        return new Int16(value);
    }

    public static PrimitiveValue newUint16(int value) {
        return new Uint16(value);
    }

    public static PrimitiveValue newInt32(int value) {
        return new Int32(value);
    }

    public static PrimitiveValue newUint32(long value) {
        return new Uint32(value);
    }

    public static PrimitiveValue newInt64(long value) {
        return new Int64(value);
    }

    public static PrimitiveValue newUint64(long value) {
        return new Uint64(value);
    }

    public static PrimitiveValue newFloat(float value) {
        return new FloatValue(value);
    }

    public static PrimitiveValue newDouble(double value) {
        return new DoubleValue(value);
    }

    public static PrimitiveValue newBytes(byte[] value) {
        return value.length == 0 ? Bytes.EMPTY_STRING : new Bytes(PrimitiveType.Bytes, (byte[])value.clone());
    }

    public static PrimitiveValue newBytes(ByteString value) {
        return value.isEmpty() ? Bytes.EMPTY_STRING : new Bytes(PrimitiveType.Bytes, value);
    }

    public static PrimitiveValue newBytesOwn(byte[] value) {
        return value.length == 0 ? Bytes.EMPTY_STRING : new Bytes(PrimitiveType.Bytes, value);
    }

    public static PrimitiveValue newText(String value) {
        return value.isEmpty() ? Text.EMPTY_TEXT : new Text(PrimitiveType.Text, value);
    }

    public static PrimitiveValue newYson(byte[] value) {
        return value.length == 0 ? Bytes.EMPTY_YSON : new Bytes(PrimitiveType.Yson, (byte[])value.clone());
    }

    public static PrimitiveValue newYson(ByteString value) {
        return value.isEmpty() ? Bytes.EMPTY_YSON : new Bytes(PrimitiveType.Yson, value);
    }

    public static PrimitiveValue newYsonOwn(byte[] value) {
        return value.length == 0 ? Bytes.EMPTY_YSON : new Bytes(PrimitiveType.Yson, value);
    }

    public static PrimitiveValue newJson(String value) {
        return value.isEmpty() ? Text.EMPTY_JSON : new Text(PrimitiveType.Json, value);
    }

    public static PrimitiveValue newJsonDocument(String value) {
        return value.isEmpty() ? Text.EMPTY_JSON_DOCUMENT : new Text(PrimitiveType.JsonDocument, value);
    }

    public static PrimitiveValue newUuid(long high, long low) {
        return new Uuid(high, low);
    }

    public static PrimitiveValue newUuid(UUID uuid) {
        return new Uuid(uuid);
    }

    public static PrimitiveValue newUuid(String uuid) {
        return new Uuid(uuid);
    }

    public static PrimitiveValue newDate(long daysSinceEpoch) {
        if (daysSinceEpoch < 0L) {
            throw new IllegalArgumentException("negative daysSinceEpoch: " + daysSinceEpoch);
        }
        return new InstantValue(PrimitiveType.Date, TimeUnit.DAYS.toMicros(daysSinceEpoch));
    }

    public static PrimitiveValue newDate(LocalDate value) {
        return PrimitiveValue.newDate(value.toEpochDay());
    }

    public static PrimitiveValue newDate(Instant value) {
        return PrimitiveValue.newDate(TimeUnit.SECONDS.toDays(value.getEpochSecond()));
    }

    public static PrimitiveValue newDatetime(long secondsSinceEpoch) {
        if (secondsSinceEpoch < 0L) {
            throw new IllegalArgumentException("negative secondsSinceEpoch: " + secondsSinceEpoch);
        }
        return new InstantValue(PrimitiveType.Datetime, TimeUnit.SECONDS.toMicros(secondsSinceEpoch));
    }

    public static PrimitiveValue newDatetime(Instant value) {
        return PrimitiveValue.newDatetime(value.getEpochSecond());
    }

    public static PrimitiveValue newDatetime(LocalDateTime value) {
        return PrimitiveValue.newDatetime(value.toEpochSecond(ZoneOffset.UTC));
    }

    public static PrimitiveValue newTimestamp(long microsSinceEpoch) {
        if (microsSinceEpoch < 0L) {
            throw new IllegalArgumentException("negative microsSinceEpoch: " + microsSinceEpoch);
        }
        return new InstantValue(PrimitiveType.Timestamp, microsSinceEpoch);
    }

    public static PrimitiveValue newTimestamp(Instant value) {
        long micros = TimeUnit.SECONDS.toMicros(value.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(value.getNano());
        return new InstantValue(PrimitiveType.Timestamp, micros);
    }

    public static PrimitiveValue newInterval(long micros) {
        return new IntervalValue(micros);
    }

    public static PrimitiveValue newInterval(Duration value) {
        return PrimitiveValue.newInterval(TimeUnit.NANOSECONDS.toMicros(value.toNanos()));
    }

    public static PrimitiveValue newTzDate(ZonedDateTime dateTime) {
        return new TzDatetime(PrimitiveType.TzDate, dateTime);
    }

    public static PrimitiveValue newTzDatetime(ZonedDateTime dateTime) {
        return new TzDatetime(PrimitiveType.TzDatetime, dateTime);
    }

    public static PrimitiveValue newTzTimestamp(ZonedDateTime dateTime) {
        return new TzDatetime(PrimitiveType.TzTimestamp, dateTime);
    }

    private static void checkType(PrimitiveType expected, PrimitiveType actual) {
        if (expected != actual) {
            throw new IllegalStateException("types mismatch, expected " + expected + ", but was " + actual);
        }
    }

    private static final class TzDatetime
    extends PrimitiveValue {
        private final PrimitiveType type;
        private final ZonedDateTime dateTime;

        TzDatetime(PrimitiveType type, ZonedDateTime dateTime) {
            this.type = type;
            this.dateTime = dateTime;
        }

        @Override
        public PrimitiveType getType() {
            return this.type;
        }

        @Override
        public ZonedDateTime getTzDate() {
            PrimitiveValue.checkType(PrimitiveType.TzDate, this.type);
            return this.dateTime;
        }

        @Override
        public ZonedDateTime getTzDatetime() {
            PrimitiveValue.checkType(PrimitiveType.TzDatetime, this.type);
            return this.dateTime;
        }

        @Override
        public ZonedDateTime getTzTimestamp() {
            PrimitiveValue.checkType(PrimitiveType.TzTimestamp, this.type);
            return this.dateTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TzDatetime that = (TzDatetime)o;
            return this.type == that.type && this.dateTime.equals(that.dateTime);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.dateTime.hashCode();
            return result;
        }

        public String toString() {
            String timeStr = this.type == PrimitiveType.TzDate ? this.dateTime.toLocalDate().toString() : this.dateTime.toLocalDateTime().toString();
            return timeStr + ',' + this.dateTime.getZone().getId();
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromText(this.toString());
        }
    }

    private static final class IntervalValue
    extends PrimitiveValue {
        private final long micros;

        IntervalValue(long micros) {
            this.micros = micros;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Interval;
        }

        @Override
        public Duration getInterval() {
            return Duration.of(this.micros, ChronoUnit.MICROS);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntervalValue that = (IntervalValue)o;
            return this.micros == that.micros;
        }

        public int hashCode() {
            return (int)(this.micros ^ this.micros >>> 32);
        }

        public String toString() {
            return this.getInterval().toString();
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromInterval(this.micros);
        }
    }

    private static final class InstantValue
    extends PrimitiveValue {
        private final PrimitiveType type;
        private final long microsSinceEpoch;

        InstantValue(PrimitiveType type, long microsSinceEpoch) {
            this.type = type;
            this.microsSinceEpoch = microsSinceEpoch;
        }

        @Override
        public PrimitiveType getType() {
            return this.type;
        }

        @Override
        public LocalDate getDate() {
            PrimitiveValue.checkType(PrimitiveType.Date, this.type);
            return ProtoValue.toDate(TimeUnit.MICROSECONDS.toDays(this.microsSinceEpoch));
        }

        @Override
        public LocalDateTime getDatetime() {
            PrimitiveValue.checkType(PrimitiveType.Datetime, this.type);
            return ProtoValue.toDatetime(TimeUnit.MICROSECONDS.toSeconds(this.microsSinceEpoch));
        }

        @Override
        public Instant getTimestamp() {
            PrimitiveValue.checkType(PrimitiveType.Timestamp, this.type);
            return ProtoValue.toTimestamp(this.microsSinceEpoch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstantValue that = (InstantValue)o;
            return this.microsSinceEpoch == that.microsSinceEpoch && this.type == that.type;
        }

        public int hashCode() {
            return 31 * this.type.hashCode() + (int)(this.microsSinceEpoch ^ this.microsSinceEpoch >>> 32);
        }

        public String toString() {
            switch (this.type) {
                case Date: {
                    return DateTimeFormatter.ISO_DATE.format(this.getDate());
                }
                case Datetime: {
                    return DateTimeFormatter.ISO_DATE_TIME.format(this.getDatetime());
                }
                case Timestamp: {
                    return DateTimeFormatter.ISO_INSTANT.format(this.getTimestamp());
                }
            }
            throw new IllegalStateException("unsupported type: " + this.type);
        }

        @Override
        public ValueProtos.Value toPb() {
            switch (this.type) {
                case Date: {
                    return ProtoValue.fromDate(TimeUnit.MICROSECONDS.toDays(this.microsSinceEpoch));
                }
                case Datetime: {
                    return ProtoValue.fromDatetime(TimeUnit.MICROSECONDS.toSeconds(this.microsSinceEpoch));
                }
                case Timestamp: {
                    return ProtoValue.fromTimestamp(this.microsSinceEpoch);
                }
            }
            throw new IllegalStateException("unsupported type: " + this.type);
        }
    }

    private static final class Uuid
    extends PrimitiveValue {
        private final long high;
        private final long low;

        Uuid(long high, long low) {
            this.high = high;
            this.low = low;
        }

        Uuid(String value) {
            String[] components = value.split("-");
            if (components.length != 5) {
                throw new IllegalArgumentException("invalid UUID string: " + value);
            }
            long timeLow = Long.parseLong(components[0], 16);
            long timeMid = Long.parseLong(components[1], 16) << 32;
            long timeHighAndVersion = Long.parseLong(components[2], 16) << 48;
            this.low = timeLow | timeMid | timeHighAndVersion;
            long lsb = Long.parseLong(components[3], 16) << 48;
            this.high = LittleEndian.bswap(lsb |= Long.parseLong(components[4], 16));
        }

        Uuid(UUID uuid) {
            long msb = uuid.getMostSignificantBits();
            long timeLow = (msb & 0xFFFFFFFF00000000L) >>> 32;
            long timeMid = (msb & 0xFFFF0000L) << 16;
            long timeHighAndVersion = (msb & 0xFFFFL) << 48;
            this.low = timeLow | timeMid | timeHighAndVersion;
            this.high = LittleEndian.bswap(uuid.getLeastSignificantBits());
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Uuid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Uuid uuid = (Uuid)o;
            return this.high == uuid.high && this.low == uuid.low;
        }

        public int hashCode() {
            int result = (int)(this.high ^ this.high >>> 32);
            result = 31 * result + (int)(this.low ^ this.low >>> 32);
            return result;
        }

        public String toString() {
            return '\"' + this.getUuidString() + '\"';
        }

        @Override
        public String getUuidString() {
            long hiBe = LittleEndian.bswap(this.high);
            return Uuid.digits(this.low, 8) + "-" + Uuid.digits(this.low >>> 32, 4) + "-" + Uuid.digits(this.low >>> 48, 4) + "-" + Uuid.digits(hiBe >> 48, 4) + "-" + Uuid.digits(hiBe, 12);
        }

        @Override
        public long getUuidHigh() {
            return this.high;
        }

        @Override
        public long getUuidLow() {
            return this.low;
        }

        @Override
        public UUID getUuidJdk() {
            long timeLow = (this.low & 0xFFFFFFFFL) << 32;
            long timeMid = (this.low & 0xFFFF00000000L) >>> 16;
            long timeHighAndVersion = (this.low & 0xFFFF000000000000L) >>> 48;
            long hiBe = LittleEndian.bswap(this.high);
            return new UUID(timeLow | timeMid | timeHighAndVersion, hiBe);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromUuid(this.high, this.low);
        }

        private static String digits(long val, int digits) {
            long high = 1L << digits * 4;
            return Long.toHexString(high | val & high - 1L).substring(1);
        }
    }

    private static final class Text
    extends PrimitiveValue {
        private static final Text EMPTY_TEXT = new Text(PrimitiveType.Text, "");
        private static final Text EMPTY_JSON = new Text(PrimitiveType.Json, "");
        private static final Text EMPTY_JSON_DOCUMENT = new Text(PrimitiveType.JsonDocument, "");
        private static final Escaper ESCAPER = Escapers.builder().addEscape('\\', "\\\\").addEscape('\"', "\\\"").build();
        private final PrimitiveType type;
        private final String value;

        Text(PrimitiveType type, String value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return this.type;
        }

        @Override
        public String getText() {
            PrimitiveValue.checkType(PrimitiveType.Text, this.type);
            return this.value;
        }

        @Override
        public String getJson() {
            PrimitiveValue.checkType(PrimitiveType.Json, this.type);
            return this.value;
        }

        @Override
        public String getJsonDocument() {
            PrimitiveValue.checkType(PrimitiveType.JsonDocument, this.type);
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Text that = (Text)o;
            if (this.type != that.type) {
                return false;
            }
            return that.value.equals(this.value);
        }

        public int hashCode() {
            return 31 * this.type.hashCode() + this.value.hashCode();
        }

        public String toString() {
            if (this.value.isEmpty()) {
                return "\"\"";
            }
            return '\"' + ESCAPER.escape(this.value) + '\"';
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromText(this.value);
        }
    }

    private static final class Bytes
    extends PrimitiveValue {
        private static final Bytes EMPTY_STRING = new Bytes(PrimitiveType.Bytes, new byte[0]);
        private static final Bytes EMPTY_YSON = new Bytes(PrimitiveType.Yson, new byte[0]);
        private final PrimitiveType type;
        private final Object value;

        private Bytes(PrimitiveType type, byte[] value) {
            this.type = type;
            this.value = value;
        }

        private Bytes(PrimitiveType type, ByteString value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return this.type;
        }

        @Override
        public byte[] getBytes() {
            return this.getBytes(PrimitiveType.Bytes);
        }

        @Override
        public byte[] getBytesUnsafe() {
            return this.getBytesUnsafe(PrimitiveType.Bytes);
        }

        @Override
        public ByteString getBytesAsByteString() {
            return this.getByteString(PrimitiveType.Bytes);
        }

        @Override
        public byte[] getYson() {
            return this.getBytes(PrimitiveType.Yson);
        }

        @Override
        public byte[] getYsonUnsafe() {
            return this.getBytesUnsafe(PrimitiveType.Yson);
        }

        @Override
        public ByteString getYsonBytes() {
            return this.getByteString(PrimitiveType.Yson);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bytes that = (Bytes)o;
            if (this.type != that.type) {
                return false;
            }
            if (this.value instanceof byte[]) {
                if (that.value instanceof byte[]) {
                    return Arrays.equals((byte[])this.value, (byte[])that.value);
                }
                return that.value.equals(UnsafeByteOperations.unsafeWrap((byte[])this.value));
            }
            if (that.value instanceof byte[]) {
                return this.value.equals(UnsafeByteOperations.unsafeWrap((byte[])that.value));
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            if (this.value instanceof byte[]) {
                for (byte b : (byte[])this.value) {
                    result = 31 * result + b;
                }
            } else {
                ByteString v = (ByteString)this.value;
                for (int i = 0; i < v.size(); ++i) {
                    byte b = v.byteAt(i);
                    result = 31 * result + b;
                }
            }
            return result;
        }

        public String toString() {
            int length;
            int n = length = this.value instanceof byte[] ? ((byte[])this.value).length : ((ByteString)this.value).size();
            if (length == 0) {
                return "\"\"";
            }
            StringBuilder sb = new StringBuilder(length * 4 + 2);
            sb.append('\"');
            if (this.value instanceof byte[]) {
                for (byte b : (byte[])this.value) {
                    Bytes.encodeAsOctal(sb, b);
                }
            } else {
                ByteString bytes = (ByteString)this.value;
                for (int i = 0; i < bytes.size(); ++i) {
                    Bytes.encodeAsOctal(sb, bytes.byteAt(i));
                }
            }
            sb.append('\"');
            return sb.toString();
        }

        private static void encodeAsOctal(StringBuilder sb, byte b) {
            int i = Byte.toUnsignedInt(b);
            sb.append('\\');
            if (i < 64) {
                sb.append('0');
                if (i < 8) {
                    sb.append('0');
                }
            }
            sb.append(Integer.toString(i, 8));
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromBytes(this.getByteString(this.type));
        }

        private byte[] getBytes(PrimitiveType expected) {
            PrimitiveValue.checkType(expected, this.type);
            if (this.value instanceof byte[]) {
                return (byte[])((byte[])this.value).clone();
            }
            return ((ByteString)this.value).toByteArray();
        }

        private byte[] getBytesUnsafe(PrimitiveType expected) {
            PrimitiveValue.checkType(expected, this.type);
            if (this.value instanceof byte[]) {
                return (byte[])this.value;
            }
            return ((ByteString)this.value).toByteArray();
        }

        private ByteString getByteString(PrimitiveType expected) {
            PrimitiveValue.checkType(expected, this.type);
            if (this.value instanceof byte[]) {
                return UnsafeByteOperations.unsafeWrap((byte[])this.value);
            }
            return (ByteString)this.value;
        }
    }

    private static final class DoubleValue
    extends PrimitiveValue {
        private final double value;

        DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Double;
        }

        @Override
        public double getDouble() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleValue that = (DoubleValue)o;
            return Double.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        public String toString() {
            return Double.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromDouble(this.value);
        }
    }

    private static final class FloatValue
    extends PrimitiveValue {
        private final float value;

        FloatValue(float value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Float;
        }

        @Override
        public float getFloat() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FloatValue that = (FloatValue)o;
            return Float.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            return Float.hashCode(this.value);
        }

        public String toString() {
            return Float.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromFloat(this.value);
        }
    }

    private static final class Uint64
    extends PrimitiveValue {
        private final long value;

        Uint64(long value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Uint64;
        }

        @Override
        public long getUint64() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Uint64)o).value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public String toString() {
            return Long.toUnsignedString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromUint64(this.value);
        }
    }

    private static final class Int64
    extends PrimitiveValue {
        private final long value;

        Int64(long value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Int64;
        }

        @Override
        public long getInt64() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Int64)o).value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public String toString() {
            return Long.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromInt64(this.value);
        }
    }

    private static final class Uint32
    extends PrimitiveValue {
        private final long value;

        Uint32(long value) {
            this.value = value & 0xFFFFFFFFL;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Uint32;
        }

        @Override
        public long getUint32() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Uint32)o).value;
        }

        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public String toString() {
            return Long.toUnsignedString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromUint32(this.value);
        }
    }

    private static final class Int32
    extends PrimitiveValue {
        private final int value;

        Int32(int value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Int32;
        }

        @Override
        public int getInt32() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Int32)o).value;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromInt32(this.value);
        }
    }

    private static final class Uint16
    extends PrimitiveValue {
        private final int value;

        Uint16(int value) {
            this.value = value & 0xFFFF;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Uint16;
        }

        @Override
        public int getUint16() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Uint16)o).value;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public String toString() {
            return Integer.toUnsignedString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromUint16(this.value);
        }
    }

    private static final class Int16
    extends PrimitiveValue {
        private final short value;

        Int16(short value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Int16;
        }

        @Override
        public short getInt16() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Int16)o).value;
        }

        public int hashCode() {
            return Short.hashCode(this.value);
        }

        public String toString() {
            return Short.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromInt16(this.value);
        }
    }

    private static final class Uint8
    extends PrimitiveValue {
        private final int value;

        Uint8(int value) {
            this.value = value & 0xFF;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Uint8;
        }

        @Override
        public int getUint8() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Uint8)o).value;
        }

        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        public String toString() {
            return Integer.toUnsignedString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromUint8(this.value);
        }
    }

    private static final class Int8
    extends PrimitiveValue {
        private final byte value;

        Int8(byte value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Int8;
        }

        @Override
        public byte getInt8() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Int8)o).value;
        }

        public int hashCode() {
            return Byte.hashCode(this.value);
        }

        public String toString() {
            return Byte.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromInt8(this.value);
        }
    }

    private static final class Bool
    extends PrimitiveValue {
        private static final Bool TRUE = new Bool(true);
        private static final Bool FALSE = new Bool(false);
        private final boolean value;

        private Bool(boolean value) {
            this.value = value;
        }

        @Override
        public PrimitiveType getType() {
            return PrimitiveType.Bool;
        }

        @Override
        public boolean getBool() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value == ((Bool)o).value;
        }

        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        public String toString() {
            return Boolean.toString(this.value);
        }

        @Override
        public ValueProtos.Value toPb() {
            return ProtoValue.fromBool(this.value);
        }
    }
}

