/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.google.common.collect.ImmutableList;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.javax.annotation.ParametersAreNonnullByDefault;
import tech.ydb.table.values.PrimitiveValue;
import tech.ydb.table.values.TupleValue;

@ParametersAreNonnullByDefault
public class ReadTableSettings
extends BaseRequestSettings {
    private final boolean ordered;
    private final TupleValue fromKey;
    private final boolean fromInclusive;
    private final TupleValue toKey;
    private final boolean toInclusive;
    private final int rowLimit;
    private final ImmutableList<String> columns;
    private final int batchLimitBytes;
    private final int batchLimitRows;

    private ReadTableSettings(Builder builder) {
        super(builder);
        this.ordered = builder.ordered;
        this.fromKey = builder.fromKey;
        this.fromInclusive = builder.fromInclusive;
        this.toKey = builder.toKey;
        this.toInclusive = builder.toInclusive;
        this.rowLimit = builder.rowLimit;
        this.columns = ImmutableList.copyOf(builder.columns);
        this.batchLimitBytes = builder.batchLimitBytes;
        this.batchLimitRows = builder.batchLimitRows;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    @Nullable
    public TupleValue getFromKey() {
        return this.fromKey;
    }

    public boolean isFromInclusive() {
        return this.fromInclusive;
    }

    @Nullable
    public TupleValue getToKey() {
        return this.toKey;
    }

    public boolean isToInclusive() {
        return this.toInclusive;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public ImmutableList<String> getColumns() {
        return this.columns;
    }

    public int batchLimitBytes() {
        return this.batchLimitBytes;
    }

    public int batchLimitRows() {
        return this.batchLimitRows;
    }

    public static final class Builder
    extends BaseRequestSettings.BaseBuilder<Builder> {
        private boolean ordered = false;
        private TupleValue fromKey = null;
        private boolean fromInclusive = false;
        private TupleValue toKey = null;
        private boolean toInclusive = false;
        private int rowLimit = 0;
        private List<String> columns = Collections.emptyList();
        private int batchLimitBytes = 0;
        private int batchLimitRows = 0;

        public Builder orderedRead(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public Builder fromKey(TupleValue value, boolean inclusive) {
            this.fromKey = value;
            this.fromInclusive = inclusive;
            return this;
        }

        public Builder toKey(TupleValue value, boolean inclusive) {
            this.toKey = value;
            this.toInclusive = inclusive;
            return this;
        }

        public Builder fromKeyInclusive(TupleValue value) {
            return this.fromKey(value, true);
        }

        public Builder fromKeyExclusive(TupleValue value) {
            return this.fromKey(value, false);
        }

        public Builder fromKeyInclusive(PrimitiveValue value) {
            return this.fromKey(TupleValue.of(value.makeOptional()), true);
        }

        public Builder fromKeyExclusive(PrimitiveValue value) {
            return this.fromKey(TupleValue.of(value.makeOptional()), false);
        }

        public Builder toKeyInclusive(TupleValue value) {
            return this.toKey(value, true);
        }

        public Builder toKeyExclusive(TupleValue value) {
            return this.toKey(value, false);
        }

        public Builder toKeyInclusive(PrimitiveValue value) {
            return this.toKey(TupleValue.of(value.makeOptional()), true);
        }

        public Builder toKeyExclusive(PrimitiveValue value) {
            return this.toKey(TupleValue.of(value.makeOptional()), false);
        }

        public Builder rowLimit(int rowLimit) {
            Preconditions.checkArgument(rowLimit >= 0, "rowLimit(%d) is negative", rowLimit);
            this.rowLimit = rowLimit;
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public Builder columns(String ... columns) {
            this.columns = ImmutableList.copyOf(columns);
            return this;
        }

        public Builder column(String column) {
            if (!(this.columns instanceof ArrayList)) {
                this.columns = new ArrayList<String>(this.columns);
            }
            this.columns.add(column);
            return this;
        }

        public Builder batchLimitBytes(int batchLimitBytes) {
            this.batchLimitBytes = batchLimitBytes;
            return this;
        }

        public Builder batchLimitRows(int batchLimitRows) {
            this.batchLimitRows = batchLimitRows;
            return this;
        }

        @Override
        public ReadTableSettings build() {
            return new ReadTableSettings(this);
        }
    }
}

