/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.table.values.StructValue;

public class ReadRowsSettings
extends BaseRequestSettings {
    private final List<String> columns;
    private final List<StructValue> keys;

    protected ReadRowsSettings(ReadRowsSettingsBuilder builder) {
        super(builder);
        this.columns = builder.columns;
        this.keys = builder.keys;
    }

    public static ReadRowsSettingsBuilder newBuilder() {
        return new ReadRowsSettingsBuilder();
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<StructValue> getKeys() {
        return this.keys;
    }

    public static class ReadRowsSettingsBuilder
    extends BaseRequestSettings.BaseBuilder<ReadRowsSettingsBuilder> {
        private final List<String> columns = new ArrayList<String>();
        private final List<StructValue> keys = new ArrayList<StructValue>();

        protected ReadRowsSettingsBuilder() {
        }

        public ReadRowsSettingsBuilder addColumns(List<String> columns) {
            this.columns.addAll((Collection<String>)Objects.requireNonNull(columns, "null is unsupported value in `withColumns(List<String> columns)`"));
            return (ReadRowsSettingsBuilder)this.self();
        }

        public ReadRowsSettingsBuilder addColumns(String ... columns) {
            return this.addColumns(Arrays.asList(columns));
        }

        public ReadRowsSettingsBuilder addColumn(String column) {
            this.columns.add(Objects.requireNonNull(column, "null is unsupported value in `addColumn(String column)`"));
            return (ReadRowsSettingsBuilder)this.self();
        }

        public ReadRowsSettingsBuilder addKeys(List<StructValue> keys) {
            this.keys.addAll((Collection<StructValue>)Objects.requireNonNull(keys, "null is unsupported value in `withKeys(List<StructValue> keys)`"));
            return (ReadRowsSettingsBuilder)this.self();
        }

        public ReadRowsSettingsBuilder addKeys(StructValue ... keys) {
            return this.addKeys(Arrays.asList(keys));
        }

        public ReadRowsSettingsBuilder addKey(StructValue key) {
            this.keys.add(Objects.requireNonNull(key, "null is unsupported value in `addKey(StructValue key)`"));
            return (ReadRowsSettingsBuilder)this.self();
        }

        @Override
        public ReadRowsSettings build() {
            return new ReadRowsSettings(this);
        }
    }
}

