/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.table.description.TableColumn;
import tech.ydb.table.description.TableIndex;
import tech.ydb.table.description.TableTtl;
import tech.ydb.table.settings.Changefeed;
import tech.ydb.table.settings.PartitioningSettings;
import tech.ydb.table.settings.RequestSettings;
import tech.ydb.table.settings.TtlSettings;
import tech.ydb.table.values.OptionalType;
import tech.ydb.table.values.Type;

public class AlterTableSettings
extends RequestSettings<AlterTableSettings> {
    private final Map<String, TableColumn> addColumns = new HashMap<String, TableColumn>();
    private final Map<String, Changefeed> addChangefeeds = new HashMap<String, Changefeed>();
    private final Map<String, TableIndex> addIndexes = new HashMap<String, TableIndex>();
    private final Set<String> dropColumns = new HashSet<String>();
    private final Set<String> dropChangefeeds = new HashSet<String>();
    private final Set<String> dropIndexes = new HashSet<String>();
    @Nullable
    private TableTtl ttl;
    @Nullable
    private PartitioningSettings partitioningSettings;

    @Deprecated
    public AlterTableSettings addColumn(String name, Type type) {
        this.addColumns.put(name, new TableColumn(name, type));
        return this;
    }

    public AlterTableSettings addNonnullColumn(String name, Type type) {
        this.addColumns.put(name, new TableColumn(name, type));
        return this;
    }

    public AlterTableSettings addNonnullColumn(String name, Type type, String family) {
        this.addColumns.put(name, new TableColumn(name, type, family));
        return this;
    }

    public AlterTableSettings addNullableColumn(String name, Type type) {
        this.addColumns.put(name, new TableColumn(name, OptionalType.of(type)));
        return this;
    }

    public AlterTableSettings addNullableColumn(String name, Type type, String family) {
        this.addColumns.put(name, new TableColumn(name, OptionalType.of(type), family));
        return this;
    }

    public AlterTableSettings dropColumn(String name) {
        this.dropColumns.add(name);
        return this;
    }

    public AlterTableSettings addChangefeed(Changefeed changefeed) {
        this.addChangefeeds.put(changefeed.getName(), changefeed);
        return this;
    }

    public AlterTableSettings dropChangefeed(String changefeed) {
        this.dropChangefeeds.add(changefeed);
        return this;
    }

    public AlterTableSettings addGlobalIndex(String name, List<String> columns) {
        this.addIndexes.put(name, new TableIndex(name, columns, TableIndex.Type.GLOBAL));
        return this;
    }

    public AlterTableSettings addGlobalIndex(String name, List<String> columns, List<String> dataColumns) {
        this.addIndexes.put(name, new TableIndex(name, columns, dataColumns, TableIndex.Type.GLOBAL));
        return this;
    }

    public AlterTableSettings addGlobalUiniqueIndex(String name, List<String> columns) {
        this.addIndexes.put(name, new TableIndex(name, columns, TableIndex.Type.GLOBAL_UNIQUE));
        return this;
    }

    public AlterTableSettings addGlobalUniqueIndex(String name, List<String> columns, List<String> dataColumns) {
        this.addIndexes.put(name, new TableIndex(name, columns, dataColumns, TableIndex.Type.GLOBAL_UNIQUE));
        return this;
    }

    public AlterTableSettings addGlobalAsyncIndex(String name, List<String> columns) {
        this.addIndexes.put(name, new TableIndex(name, columns, TableIndex.Type.GLOBAL_ASYNC));
        return this;
    }

    public AlterTableSettings addGlobalAsyncIndex(String name, List<String> columns, List<String> dataColumns) {
        this.addIndexes.put(name, new TableIndex(name, columns, dataColumns, TableIndex.Type.GLOBAL_ASYNC));
        return this;
    }

    public AlterTableSettings dropIndex(String index) {
        this.dropIndexes.add(index);
        return this;
    }

    @Deprecated
    public AlterTableSettings setTtlSettings(@Nullable TtlSettings ttlSettings) {
        this.ttl = ttlSettings == null ? TableTtl.notSet() : TableTtl.dateTimeColumn(ttlSettings.getDateTimeColumn(), ttlSettings.getExpireAfterSeconds());
        return this;
    }

    public AlterTableSettings setTableTtl(@Nullable TableTtl ttl) {
        this.ttl = ttl;
        return this;
    }

    public AlterTableSettings setPartitioningSettings(@Nullable PartitioningSettings partitioningSettings) {
        this.partitioningSettings = partitioningSettings;
        return this;
    }

    public Collection<TableColumn> getAddColumns() {
        return this.addColumns.values();
    }

    public Collection<Changefeed> getAddChangefeeds() {
        return this.addChangefeeds.values();
    }

    public Collection<TableIndex> getAddIndexes() {
        return this.addIndexes.values();
    }

    public Collection<String> getDropColumns() {
        return this.dropColumns;
    }

    public Collection<String> getDropChangefeeds() {
        return this.dropChangefeeds;
    }

    public Collection<String> getDropIndexes() {
        return this.dropIndexes;
    }

    @Nullable
    public TableTtl getTableTTL() {
        return this.ttl;
    }

    @Nullable
    @Deprecated
    public TtlSettings getTtlSettings() {
        if (this.ttl.getTtlMode() == TableTtl.TtlMode.NOT_SET) {
            return null;
        }
        return new TtlSettings(this.ttl.getDateTimeColumn(), this.ttl.getExpireAfterSeconds());
    }

    @Nullable
    public PartitioningSettings getPartitioningSettings() {
        return this.partitioningSettings;
    }

    @Deprecated
    public void forEachAddColumn(BiConsumer<String, Type> fn) {
        this.addColumns.values().forEach(c -> fn.accept(c.getName(), c.getType()));
    }

    @Deprecated
    public void forEachDropColumn(Consumer<String> fn) {
        this.dropColumns.forEach(fn);
    }

    @Deprecated
    public void forEachAddChangefeed(Consumer<Changefeed> fn) {
        this.addChangefeeds.values().forEach(fn);
    }

    @Deprecated
    public void forEachDropChangefeed(Consumer<String> fn) {
        this.dropChangefeeds.forEach(fn);
    }
}

