/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.result.impl;

import java.util.Map;
import tech.ydb.proto.ValueProtos;
import tech.ydb.shaded.google.common.collect.Maps;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.result.impl.AbstractValueReader;
import tech.ydb.table.result.impl.ProtoValueReaders;
import tech.ydb.table.values.Type;

final class ProtoResultSetReader
implements ResultSetReader {
    private final ValueProtos.ResultSet resultSet;
    private final Map<String, Integer> columnIndexes;
    private final AbstractValueReader[] columnReaders;
    private int rowIndex;
    private ValueProtos.Value currentRow;

    ProtoResultSetReader(ValueProtos.ResultSet resultSet) {
        this.resultSet = resultSet;
        this.columnIndexes = Maps.newHashMapWithExpectedSize(resultSet.getColumnsCount());
        this.columnReaders = new AbstractValueReader[resultSet.getColumnsCount()];
        for (int i = 0; i < resultSet.getColumnsCount(); ++i) {
            ValueProtos.Column columnMeta = resultSet.getColumns(i);
            this.columnIndexes.put(columnMeta.getName(), i);
            this.columnReaders[i] = ProtoValueReaders.forTypeImpl(columnMeta.getType());
        }
    }

    @Override
    public boolean isTruncated() {
        return this.resultSet.getTruncated();
    }

    @Override
    public int getColumnCount() {
        return this.resultSet.getColumnsCount();
    }

    @Override
    public int getRowCount() {
        return this.resultSet.getRowsCount();
    }

    @Override
    public void setRowIndex(int index) {
        if (index < 0 || index >= this.resultSet.getRowsCount()) {
            this.currentRow = null;
        } else {
            this.rowIndex = index;
            this.currentRow = this.resultSet.getRows(index);
        }
    }

    @Override
    public boolean next() {
        if (this.rowIndex >= this.resultSet.getRowsCount()) {
            this.currentRow = null;
            return false;
        }
        this.currentRow = this.resultSet.getRows(this.rowIndex++);
        return true;
    }

    @Override
    public String getColumnName(int index) {
        return this.resultSet.getColumns(index).getName();
    }

    @Override
    public int getColumnIndex(String name) {
        Integer index = this.columnIndexes.get(name);
        return index == null ? -1 : index;
    }

    @Override
    public ValueReader getColumn(int index) {
        if (this.currentRow == null) {
            throw new IllegalStateException("empty result set or next() was never called");
        }
        AbstractValueReader reader = this.columnReaders[index];
        reader.setProtoValue(this.currentRow.getItems(index));
        return reader;
    }

    @Override
    public ValueReader getColumn(String name) {
        int index = this.columnIndex(name);
        return this.getColumn(index);
    }

    @Override
    public Type getColumnType(int index) {
        AbstractValueReader reader = this.columnReaders[index];
        return reader.getType();
    }

    private int columnIndex(String name) {
        Integer index = this.columnIndexes.get(name);
        if (index == null) {
            throw new IllegalArgumentException("unknown column '" + name + "'");
        }
        return index;
    }

    ValueProtos.ResultSet getResultSet() {
        return this.resultSet;
    }
}

