/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.query;

import java.util.List;
import tech.ydb.proto.ValueProtos;
import tech.ydb.proto.table.YdbTable;
import tech.ydb.table.query.stats.QueryStats;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.impl.ProtoValueReaders;

public class DataQueryResult {
    private final String txId;
    private final List<ValueProtos.ResultSet> resultSets;
    private final QueryStats queryStats;

    public DataQueryResult(YdbTable.ExecuteQueryResult result) {
        this.txId = result.getTxMeta().getId();
        this.resultSets = result.getResultSetsList();
        this.queryStats = result.hasQueryStats() ? new QueryStats(result.getQueryStats()) : null;
    }

    public String getTxId() {
        return this.txId;
    }

    public int getResultSetCount() {
        return this.resultSets.size();
    }

    public ResultSetReader getResultSet(int index) {
        return ProtoValueReaders.forResultSet(this.resultSets.get(index));
    }

    public boolean isTruncated(int index) {
        return this.resultSets.get(index).getTruncated();
    }

    public int getRowCount(int index) {
        return this.resultSets.get(index).getRowsCount();
    }

    public boolean isEmpty() {
        return this.txId.isEmpty() && this.resultSets.isEmpty();
    }

    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    public boolean hasQueryStats() {
        return this.queryStats != null;
    }
}

