/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.impl.pool;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import tech.ydb.core.StatusCode;
import tech.ydb.shaded.javax.annotation.concurrent.ThreadSafe;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;
import tech.ydb.table.impl.BaseSession;
import tech.ydb.table.impl.pool.SessionPool;
import tech.ydb.table.rpc.TableRpc;

@ThreadSafe
abstract class StatefulSession
extends BaseSession {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    private final Clock clock;
    private final AtomicReference<State> state;

    protected StatefulSession(String id, Clock clock, TableRpc tableRpc, boolean keepQueryText) {
        super(id, tableRpc, keepQueryText);
        this.clock = clock;
        this.state = new AtomicReference<State>(new State(Status.IDLE, clock.instant()));
    }

    @Override
    protected void updateSessionState(Throwable th, StatusCode code, boolean gracefulShutdown) {
        State current = this.state.get();
        while (!this.state.compareAndSet(current, current.updated(this.clock.instant(), th, code, gracefulShutdown))) {
            current = this.state.get();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{} updated => {}, {}", new Object[]{this.toString(), this.state.get().status, this.state.get().lastUpdate});
        }
    }

    public State state() {
        return this.state.get();
    }

    private boolean switchState(State current, State next) {
        return next != null && this.state.compareAndSet(current, next);
    }

    public class State {
        private final Status status;
        private final Instant lastActive;
        private final Instant lastUpdate;

        private State(Status status, Instant now) {
            this.status = status;
            this.lastActive = now;
            this.lastUpdate = now;
        }

        private State(Status status, Instant lastActive, Instant lastUpdate) {
            this.status = status;
            this.lastActive = lastActive;
            this.lastUpdate = lastUpdate;
        }

        public Instant lastActive() {
            return this.lastActive;
        }

        public Instant lastUpdate() {
            return this.lastUpdate;
        }

        public boolean needShutdown() {
            return this.status == Status.BROKEN || this.status == Status.NEED_SHUTDOWN;
        }

        public boolean switchToActive(Instant now) {
            return StatefulSession.this.switchState(this, this.nextState(Status.ACTIVE, now));
        }

        public boolean switchToKeepAlive(Instant now) {
            return StatefulSession.this.switchState(this, this.nextState(Status.KEEPALIVE, now));
        }

        public boolean switchToIdle(Instant now) {
            return StatefulSession.this.switchState(this, this.nextState(Status.IDLE, now));
        }

        public boolean switchToBroken(Instant now) {
            return StatefulSession.this.switchState(this, this.nextState(Status.BROKEN, now));
        }

        private State updated(Instant now, Throwable th, StatusCode code, boolean shutdownHint) {
            boolean broken;
            if (this.status == Status.BROKEN) {
                return this;
            }
            boolean bl = broken = th != null || code.isTransportError() && code != StatusCode.CLIENT_RESOURCE_EXHAUSTED || code == StatusCode.BAD_SESSION || code == StatusCode.SESSION_BUSY || code == StatusCode.INTERNAL_ERROR;
            if (broken) {
                return new State(Status.BROKEN, this.lastActive, now);
            }
            if (this.status == Status.NEED_SHUTDOWN) {
                return new State(this.status, now);
            }
            if (this.status == Status.ACTIVE) {
                if (shutdownHint) {
                    return new State(Status.NEED_SHUTDOWN, now);
                }
                return new State(this.status, now);
            }
            return new State(this.status, this.lastActive, now);
        }

        private State nextState(Status nextStatus, Instant now) {
            if (this.status == Status.BROKEN || this.status == Status.NEED_SHUTDOWN) {
                return null;
            }
            if (nextStatus == Status.BROKEN) {
                return new State(Status.BROKEN, this.lastActive, now);
            }
            if (nextStatus == Status.ACTIVE) {
                return new State(nextStatus, now);
            }
            return new State(nextStatus, this.lastActive, now);
        }
    }

    private static enum Status {
        IDLE,
        ACTIVE,
        NEED_SHUTDOWN,
        KEEPALIVE,
        BROKEN;

    }
}

