/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.impl;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import tech.ydb.core.Result;
import tech.ydb.proto.ValueProtos;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.google.common.collect.ImmutableMap;
import tech.ydb.shaded.google.common.collect.Maps;
import tech.ydb.shaded.google.common.hash.Hashing;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.javax.annotation.ParametersAreNonnullByDefault;
import tech.ydb.table.impl.BaseSession;
import tech.ydb.table.query.DataQuery;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.settings.ExecuteDataQuerySettings;
import tech.ydb.table.transaction.TxControl;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.proto.ProtoType;

final class DataQueryImpl
implements DataQuery {
    private final BaseSession session;
    private final String queryId;
    private final ImmutableMap<String, Type> types;
    private final ImmutableMap<String, ValueProtos.Type> typesPb;
    @Nullable
    private final String text;
    private final String textHash;

    DataQueryImpl(BaseSession session, String queryId, String text, boolean keepText, Map<String, ValueProtos.Type> parametersTypes) {
        this.session = session;
        this.queryId = queryId;
        this.types = DataQueryImpl.buildTypes(parametersTypes);
        this.typesPb = ImmutableMap.copyOf(parametersTypes);
        this.text = keepText ? text : null;
        this.textHash = DataQueryImpl.makeHash(text);
    }

    static String makeHash(String text) {
        return Hashing.sha256().hashString(text, StandardCharsets.UTF_8).toString();
    }

    private static ImmutableMap<String, Type> buildTypes(Map<String, ValueProtos.Type> parametersTypes) {
        ImmutableMap.Builder<String, Type> types = new ImmutableMap.Builder<String, Type>();
        for (Map.Entry<String, ValueProtos.Type> e : parametersTypes.entrySet()) {
            types.put(e.getKey(), ProtoType.fromPb(e.getValue()));
        }
        return types.build();
    }

    @Override
    public String getId() {
        return this.queryId;
    }

    @Override
    public Params newParams() {
        return new DataQueryParams(this.types, this.typesPb);
    }

    @Override
    public Map<String, Type> types() {
        return this.types;
    }

    @Override
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    String getTextHash() {
        return this.textHash;
    }

    @Override
    public CompletableFuture<Result<DataQueryResult>> execute(TxControl<?> txControl, Params params, ExecuteDataQuerySettings settings) {
        return this.session.executePreparedDataQuery(this.queryId, this.text, txControl, params, settings);
    }

    @ParametersAreNonnullByDefault
    static final class DataQueryParams
    implements Params {
        private final ImmutableMap<String, Type> types;
        private final ImmutableMap<String, ValueProtos.Type> typesPb;
        private final HashMap<String, Value<?>> params;

        DataQueryParams(ImmutableMap<String, Type> types, ImmutableMap<String, ValueProtos.Type> typesPb) {
            this.types = types;
            this.typesPb = typesPb;
            this.params = Maps.newHashMapWithExpectedSize(types.size());
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public <T extends Type> Params put(String name, Value<T> value) {
            Type type = this.types.get(name);
            Preconditions.checkArgument(type != null, "unknown parameter: %s", (Object)name);
            Value<T> prev = this.params.putIfAbsent(name, value);
            Preconditions.checkArgument(prev == null, "duplicate parameter: %s", (Object)name);
            return this;
        }

        @Override
        public Map<String, ValueProtos.TypedValue> toPb() {
            HashMap<String, ValueProtos.TypedValue> result = Maps.newHashMapWithExpectedSize(this.params.size());
            for (Map.Entry<String, Value<?>> entry : this.params.entrySet()) {
                Value<?> value = entry.getValue();
                String name = entry.getKey();
                ValueProtos.Type typePb = Objects.requireNonNull(this.typesPb.get(name));
                ValueProtos.TypedValue valuePb = ValueProtos.TypedValue.newBuilder().setType(typePb).setValue(value.toPb()).build();
                result.put(name, valuePb);
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        public Map<String, Value<?>> values() {
            return Collections.unmodifiableMap(this.params);
        }
    }
}

