/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import tech.ydb.shaded.jackson.core.JsonGenerator;
import tech.ydb.shaded.jackson.core.JsonToken;
import tech.ydb.shaded.jackson.core.type.WritableTypeId;
import tech.ydb.shaded.jackson.databind.JavaType;
import tech.ydb.shaded.jackson.databind.JsonMappingException;
import tech.ydb.shaded.jackson.databind.JsonNode;
import tech.ydb.shaded.jackson.databind.SerializerProvider;
import tech.ydb.shaded.jackson.databind.annotation.JacksonStdImpl;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tech.ydb.shaded.jackson.databind.jsontype.TypeSerializer;
import tech.ydb.shaded.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return value.toString().isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

