/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import tech.ydb.shaded.jackson.annotation.JsonFormat;
import tech.ydb.shaded.jackson.core.JsonGenerator;
import tech.ydb.shaded.jackson.databind.AnnotationIntrospector;
import tech.ydb.shaded.jackson.databind.BeanProperty;
import tech.ydb.shaded.jackson.databind.JavaType;
import tech.ydb.shaded.jackson.databind.JsonMappingException;
import tech.ydb.shaded.jackson.databind.JsonNode;
import tech.ydb.shaded.jackson.databind.JsonSerializer;
import tech.ydb.shaded.jackson.databind.SerializerProvider;
import tech.ydb.shaded.jackson.databind.introspect.AnnotatedMember;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tech.ydb.shaded.jackson.databind.jsontype.TypeSerializer;
import tech.ydb.shaded.jackson.databind.ser.ContextualSerializer;
import tech.ydb.shaded.jackson.databind.ser.std.CollectionSerializer;
import tech.ydb.shaded.jackson.databind.ser.std.StdSerializer;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T>
implements ContextualSerializer {
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> cls) {
        super(cls, false);
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle) {
        super(src);
        this._unwrapSingle = unwrapSingle;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        JsonSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            Object serDef;
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null && (serDef = intr.findContentSerializer(m)) != null) {
                ser = serializers.serializerInstance(m, serDef);
            }
        }
        if ((format = this.findFormatOverrides(serializers, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((ser = this.findContextualConvertingSerializer(serializers, property, ser)) == null) {
            ser = serializers.findValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            if (unwrapSingle == this._unwrapSingle) {
                return this;
            }
            return this._withResolved(property, unwrapSingle);
        }
        return new CollectionSerializer(serializers.constructType((Type)((Object)String.class)), true, null, ser);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null || value.size() == 0;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.contentSchema());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            this.acceptContentVisitor(v2);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1) throws JsonMappingException;

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializerProvider var3, TypeSerializer var4) throws IOException;
}

