/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import tech.ydb.shaded.jackson.core.JsonGenerator;
import tech.ydb.shaded.jackson.core.JsonToken;
import tech.ydb.shaded.jackson.core.type.WritableTypeId;
import tech.ydb.shaded.jackson.databind.JavaType;
import tech.ydb.shaded.jackson.databind.JsonMappingException;
import tech.ydb.shaded.jackson.databind.JsonNode;
import tech.ydb.shaded.jackson.databind.SerializerProvider;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tech.ydb.shaded.jackson.databind.jsontype.TypeSerializer;
import tech.ydb.shaded.jackson.databind.ser.std.StdSerializer;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

