/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import tech.ydb.shaded.jackson.core.JsonGenerator;
import tech.ydb.shaded.jackson.databind.JavaType;
import tech.ydb.shaded.jackson.databind.JsonMappingException;
import tech.ydb.shaded.jackson.databind.SerializerProvider;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tech.ydb.shaded.jackson.databind.ser.std.StdScalarSerializer;
import tech.ydb.shaded.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset(), bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

