/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.jackson.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import tech.ydb.shaded.jackson.core.JsonGenerator;
import tech.ydb.shaded.jackson.core.JsonToken;
import tech.ydb.shaded.jackson.core.type.WritableTypeId;
import tech.ydb.shaded.jackson.databind.JavaType;
import tech.ydb.shaded.jackson.databind.JsonMappingException;
import tech.ydb.shaded.jackson.databind.JsonNode;
import tech.ydb.shaded.jackson.databind.SerializationFeature;
import tech.ydb.shaded.jackson.databind.SerializerProvider;
import tech.ydb.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tech.ydb.shaded.jackson.databind.jsontype.TypeSerializer;
import tech.ydb.shaded.jackson.databind.ser.std.StdSerializer;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        gen.writeStartObject();
        gen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value) throws JsonMappingException {
        prov.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value.getClass().getName()));
    }
}

