/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.io.jsonwebtoken.io;

import tech.ydb.shaded.io.jsonwebtoken.io.SerializationException;
import tech.ydb.shaded.io.jsonwebtoken.io.Serializer;
import tech.ydb.shaded.io.jsonwebtoken.lang.Assert;
import tech.ydb.shaded.jackson.core.JsonProcessingException;
import tech.ydb.shaded.jackson.databind.ObjectMapper;

public class JacksonSerializer<T>
implements Serializer<T> {
    static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private final ObjectMapper objectMapper;

    public JacksonSerializer() {
        this(DEFAULT_OBJECT_MAPPER);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] serialize(T t) throws SerializationException {
        Assert.notNull(t, "Object to serialize cannot be null.");
        try {
            return this.writeValueAsBytes(t);
        }
        catch (JsonProcessingException e) {
            String msg = "Unable to serialize object: " + e.getMessage();
            throw new SerializationException(msg, e);
        }
    }

    protected byte[] writeValueAsBytes(T t) throws JsonProcessingException {
        return this.objectMapper.writeValueAsBytes(t);
    }
}

