/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.io.jsonwebtoken.impl.crypto;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import tech.ydb.shaded.io.jsonwebtoken.SignatureAlgorithm;
import tech.ydb.shaded.io.jsonwebtoken.impl.crypto.RsaProvider;
import tech.ydb.shaded.io.jsonwebtoken.impl.crypto.RsaSigner;
import tech.ydb.shaded.io.jsonwebtoken.impl.crypto.SignatureValidator;
import tech.ydb.shaded.io.jsonwebtoken.lang.Assert;

public class RsaSignatureValidator
extends RsaProvider
implements SignatureValidator {
    private final RsaSigner SIGNER;

    public RsaSignatureValidator(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(key instanceof RSAPrivateKey || key instanceof RSAPublicKey, "RSA Signature validation requires either a RSAPublicKey or RSAPrivateKey instance.");
        this.SIGNER = key instanceof RSAPrivateKey ? new RsaSigner(alg, key) : null;
    }

    @Override
    public boolean isValid(byte[] data, byte[] signature) {
        if (this.key instanceof PublicKey) {
            Signature sig = this.createSignatureInstance();
            PublicKey publicKey = (PublicKey)this.key;
            try {
                return this.doVerify(sig, publicKey, data, signature);
            }
            catch (Exception e) {
                String msg = "Unable to verify RSA signature using configured PublicKey. " + e.getMessage();
                throw new tech.ydb.shaded.io.jsonwebtoken.security.SignatureException(msg, e);
            }
        }
        Assert.notNull(this.SIGNER, "RSA Signer instance cannot be null.  This is a bug.  Please report it.");
        byte[] computed = this.SIGNER.sign(data);
        return MessageDigest.isEqual(computed, signature);
    }

    protected boolean doVerify(Signature sig, PublicKey publicKey, byte[] data, byte[] signature) throws InvalidKeyException, SignatureException {
        sig.initVerify(publicKey);
        sig.update(data);
        return sig.verify(signature);
    }
}

