/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.io.jsonwebtoken.impl.compression;

import tech.ydb.shaded.io.jsonwebtoken.CompressionCodec;
import tech.ydb.shaded.io.jsonwebtoken.CompressionCodecResolver;
import tech.ydb.shaded.io.jsonwebtoken.CompressionCodecs;
import tech.ydb.shaded.io.jsonwebtoken.CompressionException;
import tech.ydb.shaded.io.jsonwebtoken.Header;
import tech.ydb.shaded.io.jsonwebtoken.lang.Assert;
import tech.ydb.shaded.io.jsonwebtoken.lang.Strings;

public class DefaultCompressionCodecResolver
implements CompressionCodecResolver {
    @Override
    public CompressionCodec resolveCompressionCodec(Header header) {
        String cmpAlg = this.getAlgorithmFromHeader(header);
        boolean hasCompressionAlgorithm = Strings.hasText(cmpAlg);
        if (!hasCompressionAlgorithm) {
            return null;
        }
        if (CompressionCodecs.DEFLATE.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.DEFLATE;
        }
        if (CompressionCodecs.GZIP.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.GZIP;
        }
        throw new CompressionException("Unsupported compression algorithm '" + cmpAlg + "'");
    }

    private String getAlgorithmFromHeader(Header header) {
        Assert.notNull(header, "header cannot be null.");
        return header.getCompressionAlgorithm();
    }
}

