/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.io.jsonwebtoken;

import java.security.Key;
import java.util.Date;
import java.util.Map;
import tech.ydb.shaded.io.jsonwebtoken.Claims;
import tech.ydb.shaded.io.jsonwebtoken.Clock;
import tech.ydb.shaded.io.jsonwebtoken.CompressionCodecResolver;
import tech.ydb.shaded.io.jsonwebtoken.ExpiredJwtException;
import tech.ydb.shaded.io.jsonwebtoken.Header;
import tech.ydb.shaded.io.jsonwebtoken.Jws;
import tech.ydb.shaded.io.jsonwebtoken.Jwt;
import tech.ydb.shaded.io.jsonwebtoken.JwtHandler;
import tech.ydb.shaded.io.jsonwebtoken.MalformedJwtException;
import tech.ydb.shaded.io.jsonwebtoken.SigningKeyResolver;
import tech.ydb.shaded.io.jsonwebtoken.UnsupportedJwtException;
import tech.ydb.shaded.io.jsonwebtoken.io.Decoder;
import tech.ydb.shaded.io.jsonwebtoken.io.Deserializer;
import tech.ydb.shaded.io.jsonwebtoken.security.SignatureException;

public interface JwtParser {
    public static final char SEPARATOR_CHAR = '.';

    public JwtParser requireId(String var1);

    public JwtParser requireSubject(String var1);

    public JwtParser requireAudience(String var1);

    public JwtParser requireIssuer(String var1);

    public JwtParser requireIssuedAt(Date var1);

    public JwtParser requireExpiration(Date var1);

    public JwtParser requireNotBefore(Date var1);

    public JwtParser require(String var1, Object var2);

    public JwtParser setClock(Clock var1);

    public JwtParser setAllowedClockSkewSeconds(long var1);

    public JwtParser setSigningKey(byte[] var1);

    public JwtParser setSigningKey(String var1);

    public JwtParser setSigningKey(Key var1);

    public JwtParser setSigningKeyResolver(SigningKeyResolver var1);

    public JwtParser setCompressionCodecResolver(CompressionCodecResolver var1);

    public JwtParser base64UrlDecodeWith(Decoder<String, byte[]> var1);

    public JwtParser deserializeJsonWith(Deserializer<Map<String, ?>> var1);

    public boolean isSigned(String var1);

    public Jwt parse(String var1) throws ExpiredJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public <T> T parse(String var1, JwtHandler<T> var2) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jwt<Header, String> parsePlaintextJwt(String var1) throws UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jwt<Header, Claims> parseClaimsJwt(String var1) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jws<String> parsePlaintextJws(String var1) throws UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;

    public Jws<Claims> parseClaimsJws(String var1) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException;
}

