/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.grpc.netty.shaded.io.grpc.netty;

import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.grpc.Internal;
import tech.ydb.shaded.grpc.NameResolver;
import tech.ydb.shaded.grpc.NameResolverProvider;
import tech.ydb.shaded.grpc.netty.shaded.io.grpc.netty.UdsNameResolver;
import tech.ydb.shaded.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;

@Internal
public final class UdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "unix";

    @Override
    public UdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new UdsNameResolver(targetUri.getAuthority(), UdsNameResolverProvider.getTargetPathFromUri(targetUri));
        }
        return null;
    }

    static String getTargetPathFromUri(URI targetUri) {
        Preconditions.checkArgument(SCHEME.equals(targetUri.getScheme()), "scheme must be unix");
        String targetPath = targetUri.getPath();
        if (targetPath == null) {
            targetPath = Preconditions.checkNotNull(targetUri.getSchemeSpecificPart(), "targetPath");
        }
        return targetPath;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 3;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

