/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.grpc.internal;

import java.util.Map;
import tech.ydb.shaded.grpc.LoadBalancer;
import tech.ydb.shaded.grpc.LoadBalancerProvider;
import tech.ydb.shaded.grpc.NameResolver;
import tech.ydb.shaded.grpc.Status;
import tech.ydb.shaded.grpc.internal.JsonUtil;
import tech.ydb.shaded.grpc.internal.PickFirstLoadBalancer;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "pick_first";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PickFirstLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            return NameResolver.ConfigOrError.fromConfig(new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(JsonUtil.getBoolean(rawLoadBalancingPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY)));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }
}

