/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.grpc.internal;

import java.util.concurrent.Executor;
import tech.ydb.shaded.google.common.annotations.VisibleForTesting;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.google.common.util.concurrent.ListenableFuture;
import tech.ydb.shaded.google.common.util.concurrent.SettableFuture;
import tech.ydb.shaded.grpc.CallOptions;
import tech.ydb.shaded.grpc.ClientStreamTracer;
import tech.ydb.shaded.grpc.InternalChannelz;
import tech.ydb.shaded.grpc.InternalLogId;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.grpc.MethodDescriptor;
import tech.ydb.shaded.grpc.Status;
import tech.ydb.shaded.grpc.internal.ClientStream;
import tech.ydb.shaded.grpc.internal.ClientStreamListener;
import tech.ydb.shaded.grpc.internal.ClientTransport;
import tech.ydb.shaded.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

