/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.grpc;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLSession;
import tech.ydb.shaded.grpc.Attributes;
import tech.ydb.shaded.grpc.ChannelCredentials;
import tech.ydb.shaded.grpc.ExperimentalApi;
import tech.ydb.shaded.grpc.ManagedChannelBuilder;
import tech.ydb.shaded.grpc.ManagedChannelRegistry;
import tech.ydb.shaded.grpc.ServerBuilder;
import tech.ydb.shaded.grpc.ServerCredentials;
import tech.ydb.shaded.grpc.ServerRegistry;

public final class Grpc {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1710")
    public static final Attributes.Key<SocketAddress> TRANSPORT_ATTR_REMOTE_ADDR = Attributes.Key.create("tech.ydb.shaded.grpc.Grpc.TRANSPORT_ATTR_REMOTE_ADDR");
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1710")
    public static final Attributes.Key<SocketAddress> TRANSPORT_ATTR_LOCAL_ADDR = Attributes.Key.create("tech.ydb.shaded.grpc.Grpc.TRANSPORT_ATTR_LOCAL_ADDR");
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1710")
    public static final Attributes.Key<SSLSession> TRANSPORT_ATTR_SSL_SESSION = Attributes.Key.create("tech.ydb.shaded.grpc.Grpc.TRANSPORT_ATTR_SSL_SESSION");

    private Grpc() {
    }

    public static ManagedChannelBuilder<?> newChannelBuilder(String target, ChannelCredentials creds) {
        return ManagedChannelRegistry.getDefaultRegistry().newChannelBuilder(target, creds);
    }

    public static ManagedChannelBuilder<?> newChannelBuilderForAddress(String host, int port, ChannelCredentials creds) {
        return Grpc.newChannelBuilder(Grpc.authorityFromHostAndPort(host, port), creds);
    }

    private static String authorityFromHostAndPort(String host, int port) {
        try {
            return new URI(null, null, host, port, null, null, null).getAuthority();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host or port: " + host + " " + port, ex);
        }
    }

    public static ServerBuilder<?> newServerBuilderForPort(int port, ServerCredentials creds) {
        return ServerRegistry.getDefaultRegistry().newServerBuilderForPort(port, creds);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4972")
    public static @interface TransportAttr {
    }
}

