/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.grpc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tech.ydb.shaded.google.common.annotations.VisibleForTesting;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.grpc.Codec;
import tech.ydb.shaded.grpc.Compressor;
import tech.ydb.shaded.grpc.ExperimentalApi;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
@ThreadSafe
public final class CompressorRegistry {
    private static final CompressorRegistry DEFAULT_INSTANCE = new CompressorRegistry(new Codec.Gzip(), Codec.Identity.NONE);
    private final ConcurrentMap<String, Compressor> compressors = new ConcurrentHashMap<String, Compressor>();

    public static CompressorRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static CompressorRegistry newEmptyInstance() {
        return new CompressorRegistry(new Compressor[0]);
    }

    @VisibleForTesting
    CompressorRegistry(Compressor ... cs) {
        for (Compressor c : cs) {
            this.compressors.put(c.getMessageEncoding(), c);
        }
    }

    @Nullable
    public Compressor lookupCompressor(String compressorName) {
        return (Compressor)this.compressors.get(compressorName);
    }

    public void register(Compressor c) {
        String encoding = c.getMessageEncoding();
        Preconditions.checkArgument(!encoding.contains(","), "Comma is currently not allowed in message encoding");
        this.compressors.put(encoding, c);
    }
}

