/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.google.common.util.concurrent;

import tech.ydb.shaded.google.common.annotations.GwtCompatible;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import tech.ydb.shaded.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

